/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.messages.StreamCacheService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;

public class RouteToStream
extends AbstractFunction<Void> {
    public static final String NAME = "route_to_stream";
    private static final String ID_ARG = "id";
    private static final String NAME_ARG = "name";
    private final StreamCacheService streamCacheService;
    private final ParameterDescriptor<Message, Message> messageParam;
    private final ParameterDescriptor<String, String> nameParam;
    private final ParameterDescriptor<String, String> idParam;

    @Inject
    public RouteToStream(StreamCacheService streamCacheService) {
        this.streamCacheService = streamCacheService;
        this.messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
        this.nameParam = ParameterDescriptor.string(NAME_ARG).optional().description("The name of the stream to route the message to, must match exactly").build();
        this.idParam = ParameterDescriptor.string(ID_ARG).optional().description("The ID of the stream").build();
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Collection<Stream> streams;
        String id = this.idParam.optional(args, context).orElse("");
        if ("".equals(id)) {
            String name = this.nameParam.optional(args, context).orElse("");
            if ("".equals(name)) {
                return null;
            }
            streams = this.streamCacheService.getByName(name);
            if (streams.isEmpty()) {
                return null;
            }
        } else {
            Stream stream2 = this.streamCacheService.getById(id);
            if (stream2 == null) {
                return null;
            }
            streams = Collections.singleton(stream2);
        }
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        streams.forEach(stream -> {
            if (!stream.isPaused().booleanValue()) {
                message.addStream(stream);
            }
        });
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.nameParam, this.idParam, this.messageParam)).description("Routes a message to a stream").build();
    }
}

