/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Contains
extends AbstractFunction<Boolean> {
    public static final String NAME = "contains";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to check").build();
    private final ParameterDescriptor<String, String> searchParam = ParameterDescriptor.string("search").description("The substring to find").build();
    private final ParameterDescriptor<Boolean, Boolean> ignoreCaseParam = ParameterDescriptor.bool("ignore_case").optional().description("Whether to search case insensitive, defaults to false").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        String search = this.searchParam.required(args, context);
        boolean ignoreCase = this.ignoreCaseParam.optional(args, context).orElse(false);
        if (ignoreCase) {
            return StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)search);
        }
        return StringUtils.contains((CharSequence)value, (CharSequence)search);
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.searchParam, this.ignoreCaseParam)).description("Checks if a string contains a substring").build();
    }
}

