/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.inject.Inject;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.Match;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.grok.GrokPatternRegistry;

public class GrokMatch
extends AbstractFunction<GrokResult> {
    public static final String NAME = "grok";
    private final ParameterDescriptor<String, String> valueParam;
    private final ParameterDescriptor<String, String> patternParam;
    private final ParameterDescriptor<Boolean, Boolean> namedOnly;
    private final GrokPatternRegistry grokPatternRegistry;

    @Inject
    public GrokMatch(GrokPatternRegistry grokPatternRegistry) {
        this.grokPatternRegistry = grokPatternRegistry;
        this.valueParam = ParameterDescriptor.string("value").description("The string to apply the Grok pattern against").build();
        this.patternParam = ParameterDescriptor.string("pattern").description("The Grok pattern").build();
        this.namedOnly = ParameterDescriptor.bool("only_named_captures").optional().description("Whether to only use explicitly named groups in the patterns").build();
    }

    @Override
    public GrokResult evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        String pattern = this.patternParam.required(args, context);
        boolean onlyNamedCaptures = this.namedOnly.optional(args, context).orElse(false);
        if (value == null || pattern == null) {
            return null;
        }
        Grok grok = this.grokPatternRegistry.cachedGrokForPattern(pattern, onlyNamedCaptures);
        Match match = grok.match(value);
        match.captures();
        return new GrokResult(match.toMap());
    }

    @Override
    public FunctionDescriptor<GrokResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(GrokResult.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.patternParam, this.valueParam, this.namedOnly)).description("Applies a Grok pattern to a string").build();
    }

    public static class GrokResult
    extends ForwardingMap<String, Object> {
        private final Map<String, Object> captures;

        public GrokResult(Map<String, Object> captures) {
            this.captures = captures;
        }

        protected Map<String, Object> delegate() {
            return this.captures;
        }

        public boolean isMatches() {
            return this.captures.size() > 0;
        }
    }
}

