/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.urls;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class URL {
    private final java.net.URL url;
    private Map<String, String> queryMap;

    public URL(java.net.URL url) {
        this.url = url;
    }

    public URL(String urlString) throws MalformedURLException {
        this.url = URI.create(urlString).toURL();
    }

    public String getQuery() {
        return this.url.getQuery();
    }

    public Map<String, String> getQueryParams() {
        if (this.queryMap == null) {
            this.queryMap = URL.splitQuery(this.getQuery());
        }
        return this.queryMap;
    }

    private static Map<String, String> splitQuery(String query) {
        String[] kvPairs;
        HashMap nameValues = Maps.newHashMap();
        for (String pair : kvPairs = query.split("&")) {
            try {
                String value;
                int idx = pair.indexOf("=");
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                if (nameValues.containsKey(key)) {
                    nameValues.put(key, (String)nameValues.get(key) + "," + value);
                    continue;
                }
                nameValues.put(key, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return nameValues;
    }

    public String getUserInfo() {
        return this.url.getUserInfo();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String getFile() {
        return this.url.getFile();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public int getDefaultPort() {
        return this.url.getDefaultPort();
    }

    public String getFragment() {
        return this.url.getRef();
    }

    public String getRef() {
        return this.url.getRef();
    }

    public String getAuthority() {
        return this.url.getAuthority();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public boolean equals(Object obj) {
        return this.url.equals(obj);
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

