/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.periodical;

import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.events.LegacyDefaultStreamMigrated;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDefaultStreamMigration
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyDefaultStreamMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final PipelineStreamConnectionsService connectionsService;
    private static final String LEGACY_STREAM_ID = "default";

    @Inject
    public LegacyDefaultStreamMigration(ClusterConfigService clusterConfigService, PipelineStreamConnectionsService connectionsService) {
        this.clusterConfigService = clusterConfigService;
        this.connectionsService = connectionsService;
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        LegacyDefaultStreamMigrated migrationState = (LegacyDefaultStreamMigrated)this.clusterConfigService.getOrDefault(LegacyDefaultStreamMigrated.class, (Object)LegacyDefaultStreamMigrated.create(false));
        return !migrationState.migrationDone();
    }

    public boolean isDaemon() {
        return false;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        try {
            PipelineConnections defaultConnections = this.connectionsService.load(LEGACY_STREAM_ID);
            this.connectionsService.save(defaultConnections.toBuilder().streamId("000000000000000000000001").build());
            this.connectionsService.delete(LEGACY_STREAM_ID);
            this.clusterConfigService.write((Object)LegacyDefaultStreamMigrated.create(true));
            LOG.info("Pipeline connections to legacy default streams migrated successfully.");
        }
        catch (NotFoundException e) {
            LOG.info("Legacy default stream has no connections, no migration needed.");
        }
    }
}

