/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.rest.StageSource;

final class AutoValue_StageSource
extends StageSource {
    private final int stage;
    private final boolean matchAll;
    private final List<String> rules;

    private AutoValue_StageSource(int stage, boolean matchAll, List<String> rules) {
        this.stage = stage;
        this.matchAll = matchAll;
        this.rules = rules;
    }

    @Override
    @JsonProperty
    public int stage() {
        return this.stage;
    }

    @Override
    @JsonProperty
    public boolean matchAll() {
        return this.matchAll;
    }

    @Override
    @JsonProperty
    public List<String> rules() {
        return this.rules;
    }

    public String toString() {
        return "StageSource{stage=" + this.stage + ", " + "matchAll=" + this.matchAll + ", " + "rules=" + this.rules + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StageSource) {
            StageSource that = (StageSource)o;
            return this.stage == that.stage() && this.matchAll == that.matchAll() && this.rules.equals(that.rules());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.stage;
        h *= 1000003;
        h ^= this.matchAll ? 1231 : 1237;
        h *= 1000003;
        return h ^= this.rules.hashCode();
    }

    @Override
    public StageSource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends StageSource.Builder {
        private Integer stage;
        private Boolean matchAll;
        private List<String> rules;

        Builder() {
        }

        Builder(StageSource source) {
            this.stage = source.stage();
            this.matchAll = source.matchAll();
            this.rules = source.rules();
        }

        @Override
        public StageSource.Builder stage(int stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public StageSource.Builder matchAll(boolean matchAll) {
            this.matchAll = matchAll;
            return this;
        }

        @Override
        public StageSource.Builder rules(List<String> rules) {
            this.rules = rules;
            return this;
        }

        @Override
        public StageSource build() {
            String missing = "";
            if (this.stage == null) {
                missing = missing + " stage";
            }
            if (this.matchAll == null) {
                missing = missing + " matchAll";
            }
            if (this.rules == null) {
                missing = missing + " rules";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StageSource(this.stage, this.matchAll, this.rules);
        }
    }
}

