/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.graylog.plugins.pipelineprocessor.rest.AutoValue_RuleSource;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
public abstract class RuleSource {
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty
    @Nullable
    public abstract String title();

    @JsonProperty
    @Nullable
    public abstract String description();

    @JsonProperty
    public abstract String source();

    @JsonProperty
    @Nullable
    public abstract DateTime createdAt();

    @JsonProperty
    @Nullable
    public abstract DateTime modifiedAt();

    @JsonProperty
    @Nullable
    public abstract Set<ParseError> errors();

    public static Builder builder() {
        return new AutoValue_RuleSource.Builder();
    }

    public abstract Builder toBuilder();

    @JsonCreator
    public static RuleSource create(@JsonProperty(value="id") @Id @ObjectId @Nullable String id, @JsonProperty(value="title") String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="source") String source, @JsonProperty(value="created_at") @Nullable DateTime createdAt, @JsonProperty(value="modified_at") @Nullable DateTime modifiedAt) {
        return RuleSource.builder().id(id).source(source).title(title).description(description).createdAt(createdAt).modifiedAt(modifiedAt).build();
    }

    public static RuleSource fromDao(PipelineRuleParser parser, RuleDao dao) {
        Set<ParseError> errors = null;
        try {
            parser.parseRule(dao.id(), dao.source(), false);
        }
        catch (ParseException e) {
            errors = e.getErrors();
        }
        return RuleSource.builder().id(dao.id()).source(dao.source()).title(dao.title()).description(dao.description()).createdAt(dao.createdAt()).modifiedAt(dao.modifiedAt()).errors(errors).build();
    }

    public static abstract class Builder {
        public abstract RuleSource build();

        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder source(String var1);

        public abstract Builder createdAt(DateTime var1);

        public abstract Builder modifiedAt(DateTime var1);

        public abstract Builder errors(Set<ParseError> var1);
    }
}

