/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.lambda;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.FunctionalSpliterator;
import org.jooq.lambda.SeqImpl;
import org.jooq.lambda.SeqUtils;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.Window;
import org.jooq.lambda.WindowImpl;
import org.jooq.lambda.WindowSpecification;
import org.jooq.lambda.function.Function10;
import org.jooq.lambda.function.Function11;
import org.jooq.lambda.function.Function12;
import org.jooq.lambda.function.Function13;
import org.jooq.lambda.function.Function14;
import org.jooq.lambda.function.Function15;
import org.jooq.lambda.function.Function16;
import org.jooq.lambda.function.Function3;
import org.jooq.lambda.function.Function4;
import org.jooq.lambda.function.Function5;
import org.jooq.lambda.function.Function6;
import org.jooq.lambda.function.Function7;
import org.jooq.lambda.function.Function8;
import org.jooq.lambda.function.Function9;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple1;
import org.jooq.lambda.tuple.Tuple10;
import org.jooq.lambda.tuple.Tuple11;
import org.jooq.lambda.tuple.Tuple12;
import org.jooq.lambda.tuple.Tuple13;
import org.jooq.lambda.tuple.Tuple14;
import org.jooq.lambda.tuple.Tuple15;
import org.jooq.lambda.tuple.Tuple16;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.jooq.lambda.tuple.Tuple5;
import org.jooq.lambda.tuple.Tuple6;
import org.jooq.lambda.tuple.Tuple7;
import org.jooq.lambda.tuple.Tuple8;
import org.jooq.lambda.tuple.Tuple9;

public interface Seq<T>
extends Stream<T>,
Iterable<T>,
Collectable<T> {
    public Stream<T> stream();

    default public <U> Seq<Tuple2<T, U>> crossJoin(Stream<U> other) {
        return Seq.crossJoin(this, other);
    }

    default public <U> Seq<Tuple2<T, U>> crossJoin(Iterable<U> other) {
        return Seq.crossJoin(this, other);
    }

    default public <U> Seq<Tuple2<T, U>> crossJoin(Seq<U> other) {
        return Seq.crossJoin(this, other);
    }

    default public <U> Seq<Tuple2<T, U>> innerJoin(Stream<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.innerJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> innerJoin(Iterable<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.innerJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> innerJoin(Seq<U> other, BiPredicate<? super T, ? super U> predicate) {
        List list = other.toList();
        return this.flatMap((T t) -> Seq.seq(list).filter(u -> predicate.test(t, u)).map((T u) -> Tuple.tuple(t, u)));
    }

    default public <U> Seq<Tuple2<T, U>> leftOuterJoin(Stream<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.leftOuterJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> leftOuterJoin(Iterable<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.leftOuterJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> leftOuterJoin(Seq<U> other, BiPredicate<? super T, ? super U> predicate) {
        List list = other.toList();
        return this.flatMap((T t) -> Seq.seq(list).filter(u -> predicate.test(t, u)).onEmpty(null).map((T u) -> Tuple.tuple(t, u)));
    }

    default public <U> Seq<Tuple2<T, U>> rightOuterJoin(Stream<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.rightOuterJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> rightOuterJoin(Iterable<U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.rightOuterJoin(Seq.seq(other), predicate);
    }

    default public <U> Seq<Tuple2<T, U>> rightOuterJoin(Seq<U> other, BiPredicate<? super T, ? super U> predicate) {
        return other.leftOuterJoin(this, (? super T u, ? super U t) -> predicate.test(t, u)).map((T t) -> Tuple.tuple(t.v2, t.v1));
    }

    default public Seq<T> onEmpty(T value) {
        return this.onEmptyGet(() -> value);
    }

    default public Seq<T> onEmptyGet(Supplier<T> supplier) {
        boolean[] first = new boolean[]{true};
        return SeqUtils.transform(this, (delegate, action) -> {
            if (first[0]) {
                first[0] = false;
                if (!delegate.tryAdvance(action)) {
                    action.accept(supplier.get());
                }
                return true;
            }
            return delegate.tryAdvance(action);
        });
    }

    default public <X extends Throwable> Seq<T> onEmptyThrow(Supplier<X> supplier) {
        boolean[] first = new boolean[]{true};
        return SeqUtils.transform(this, (delegate, action) -> {
            if (first[0]) {
                first[0] = false;
                if (!delegate.tryAdvance(action)) {
                    SeqUtils.sneakyThrow((Throwable)supplier.get());
                }
                return true;
            }
            return delegate.tryAdvance(action);
        });
    }

    default public Seq<T> concat(Stream<T> other) {
        return this.concat((T)Seq.seq(other));
    }

    default public Seq<T> concat(Iterable<T> other) {
        return this.concat((T)Seq.seq(other));
    }

    default public Seq<T> concat(Seq<T> other) {
        return Seq.concat(this, other);
    }

    default public Seq<T> concat(T other) {
        return this.concat((T)Seq.of(other));
    }

    default public Seq<T> concat(T ... other) {
        return this.concat((T)Seq.of(other));
    }

    default public Seq<T> append(Stream<T> other) {
        return this.concat((T)other);
    }

    default public Seq<T> append(Iterable<T> other) {
        return this.concat((T)other);
    }

    default public Seq<T> append(Seq<T> other) {
        return this.concat((T)other);
    }

    default public Seq<T> append(T other) {
        return this.concat(other);
    }

    default public Seq<T> append(T ... other) {
        return this.concat(other);
    }

    default public Seq<T> prepend(Stream<T> other) {
        return Seq.seq(other).concat(this);
    }

    default public Seq<T> prepend(Iterable<T> other) {
        return Seq.seq(other).concat(this);
    }

    default public Seq<T> prepend(Seq<T> other) {
        return other.concat(this);
    }

    default public Seq<T> prepend(T other) {
        return Seq.of(other).concat(this);
    }

    default public Seq<T> prepend(T ... other) {
        return Seq.of(other).concat(this);
    }

    default public boolean contains(T other) {
        return this.anyMatch(Predicate.isEqual(other));
    }

    default public boolean containsAll(T ... other) {
        return this.containsAll(Seq.of(other));
    }

    default public boolean containsAll(Stream<T> other) {
        return this.containsAll(Seq.seq(other));
    }

    default public boolean containsAll(Iterable<T> other) {
        return this.containsAll(Seq.seq(other));
    }

    default public boolean containsAll(Seq<T> other) {
        HashSet set = other.toSet(HashSet::new);
        return set.isEmpty() ? true : this.filter((T t) -> set.remove(t)).anyMatch(t -> set.isEmpty());
    }

    default public boolean containsAny(T ... other) {
        return this.containsAny(Seq.of(other));
    }

    default public boolean containsAny(Stream<T> other) {
        return this.containsAny(Seq.seq(other));
    }

    default public boolean containsAny(Iterable<T> other) {
        return this.containsAny(Seq.seq(other));
    }

    default public boolean containsAny(Seq<T> other) {
        HashSet set = other.toSet(HashSet::new);
        return set.isEmpty() ? false : this.anyMatch(set::contains);
    }

    default public Optional<T> get(long index) {
        if (index < 0L) {
            return Optional.empty();
        }
        if (index == 0L) {
            return this.findFirst();
        }
        return this.skip(index).findFirst();
    }

    default public Seq<T> remove(T other) {
        boolean[] removed = new boolean[1];
        return this.filter((T t) -> removed[0] || !(removed[0] = Objects.equals(t, other)));
    }

    default public Seq<T> removeAll(T ... other) {
        return this.removeAll(Seq.of(other));
    }

    default public Seq<T> removeAll(Stream<T> other) {
        return this.removeAll(Seq.seq(other));
    }

    default public Seq<T> removeAll(Iterable<T> other) {
        return this.removeAll(Seq.seq(other));
    }

    default public Seq<T> removeAll(Seq<T> other) {
        HashSet set = other.toSet(HashSet::new);
        return set.isEmpty() ? this : this.filter((T t) -> !set.contains(t));
    }

    default public Seq<T> retainAll(T ... other) {
        return this.retainAll(Seq.of(other));
    }

    default public Seq<T> retainAll(Stream<T> other) {
        return this.retainAll(Seq.seq(other));
    }

    default public Seq<T> retainAll(Iterable<T> other) {
        return this.retainAll(Seq.seq(other));
    }

    default public Seq<T> retainAll(Seq<T> other) {
        HashSet set = other.toSet(HashSet::new);
        return set.isEmpty() ? Seq.empty() : this.filter((T t) -> set.contains(t));
    }

    default public Seq<T> cycle() {
        return Seq.cycle(this);
    }

    default public <U> Seq<T> distinct(Function<? super T, ? extends U> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return this.filter((T t) -> seen.put(keyExtractor.apply(t), "") == null);
    }

    default public <U> Seq<Tuple2<T, U>> zip(Stream<U> other) {
        return this.zip(Seq.seq(other));
    }

    default public <U> Seq<Tuple2<T, U>> zip(Iterable<U> other) {
        return this.zip(Seq.seq(other));
    }

    default public <U> Seq<Tuple2<T, U>> zip(Seq<U> other) {
        return Seq.zip(this, other);
    }

    default public <U, R> Seq<R> zip(Stream<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.zip(Seq.seq(other), zipper);
    }

    default public <U, R> Seq<R> zip(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.zip(Seq.seq(other), zipper);
    }

    default public <U, R> Seq<R> zip(Seq<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Seq.zip(this, other, zipper);
    }

    default public Seq<Tuple2<T, Long>> zipWithIndex() {
        return Seq.zipWithIndex(this);
    }

    default public <U> U foldLeft(U seed, BiFunction<U, ? super T, U> function) {
        return Seq.foldLeft(this, seed, function);
    }

    default public <U> U foldRight(U seed, BiFunction<? super T, U, U> function) {
        return Seq.foldRight(this, seed, function);
    }

    default public <U> Seq<U> scanLeft(U seed, BiFunction<U, ? super T, U> function) {
        return Seq.scanLeft(this, seed, function);
    }

    default public <U> Seq<U> scanRight(U seed, BiFunction<? super T, U, U> function) {
        return Seq.scanRight(this, seed, function);
    }

    default public Seq<T> reverse() {
        return Seq.reverse(this);
    }

    default public Seq<T> shuffle() {
        return Seq.shuffle(this);
    }

    default public Seq<T> shuffle(Random random) {
        return Seq.shuffle(this, random);
    }

    default public Seq<T> skipWhile(Predicate<? super T> predicate) {
        return Seq.skipWhile(this, predicate);
    }

    default public Seq<T> skipWhileClosed(Predicate<? super T> predicate) {
        return Seq.skipWhileClosed(this, predicate);
    }

    default public Seq<T> skipUntil(Predicate<? super T> predicate) {
        return Seq.skipUntil(this, predicate);
    }

    default public Seq<T> skipUntilClosed(Predicate<? super T> predicate) {
        return Seq.skipUntilClosed(this, predicate);
    }

    default public Seq<T> limitWhile(Predicate<? super T> predicate) {
        return Seq.limitWhile(this, predicate);
    }

    default public Seq<T> limitWhileClosed(Predicate<? super T> predicate) {
        return Seq.limitWhileClosed(this, predicate);
    }

    default public Seq<T> limitUntil(Predicate<? super T> predicate) {
        return Seq.limitUntil(this, predicate);
    }

    default public Seq<T> limitUntilClosed(Predicate<? super T> predicate) {
        return Seq.limitUntilClosed(this, predicate);
    }

    default public Seq<T> intersperse(T value) {
        return Seq.intersperse(this, value);
    }

    default public Tuple2<Seq<T>, Seq<T>> duplicate() {
        return Seq.duplicate(this);
    }

    default public <K> Seq<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return Seq.grouped(this, classifier);
    }

    default public <K, A, D> Seq<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.grouped(this, classifier, downstream);
    }

    default public Tuple2<Seq<T>, Seq<T>> partition(Predicate<? super T> predicate) {
        return Seq.partition(this, predicate);
    }

    default public Tuple2<Seq<T>, Seq<T>> splitAt(long position) {
        return Seq.splitAt(this, position);
    }

    default public Tuple2<Optional<T>, Seq<T>> splitAtHead() {
        return Seq.splitAtHead(this);
    }

    default public Seq<T> slice(long from, long to) {
        return Seq.slice(this, from, to);
    }

    default public boolean isEmpty() {
        return !this.findAny().isPresent();
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public <U extends Comparable<? super U>> Seq<T> sorted(Function<? super T, ? extends U> function) {
        return this.sorted((Comparator)Comparator.comparing(function));
    }

    default public <U> Seq<T> sorted(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.sorted((Comparator)Comparator.comparing(function, comparator));
    }

    default public <U> Seq<U> ofType(Class<U> type) {
        return Seq.ofType(this, type);
    }

    default public <U> Seq<U> cast(Class<U> type) {
        return Seq.cast(this, type);
    }

    default public Seq<Window<T>> window() {
        return this.window(Window.of()).map((T t) -> (Window)t.v1);
    }

    default public Seq<Window<T>> window(long lower, long upper) {
        return this.window(Window.of(lower, upper)).map((T t) -> (Window)t.v1);
    }

    default public Seq<Window<T>> window(Comparator<? super T> orderBy) {
        return this.window(Window.of(orderBy)).map((T t) -> (Window)t.v1);
    }

    default public Seq<Window<T>> window(Comparator<? super T> orderBy, long lower, long upper) {
        return this.window(Window.of(orderBy, lower, upper)).map((T t) -> (Window)t.v1);
    }

    default public <U> Seq<Window<T>> window(Function<? super T, ? extends U> partitionBy) {
        return this.window(Window.of(partitionBy)).map((T t) -> (Window)t.v1);
    }

    default public <U> Seq<Window<T>> window(Function<? super T, ? extends U> partitionBy, long lower, long upper) {
        return this.window(Window.of(partitionBy, lower, upper)).map((T t) -> (Window)t.v1);
    }

    default public <U> Seq<Window<T>> window(Function<? super T, ? extends U> partitionBy, Comparator<? super T> orderBy) {
        return this.window(Window.of(partitionBy, orderBy)).map((T t) -> (Window)t.v1);
    }

    default public <U> Seq<Window<T>> window(Function<? super T, ? extends U> partitionBy, Comparator<? super T> orderBy, long lower, long upper) {
        return this.window(Window.of(partitionBy, orderBy, lower, upper)).map((T t) -> (Window)t.v1);
    }

    default public Seq<Tuple1<Window<T>>> window(WindowSpecification<T> specification1) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1)));
    }

    default public Seq<Tuple2<Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2)));
    }

    default public Seq<Tuple3<Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3)));
    }

    default public Seq<Tuple4<Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4)));
    }

    default public Seq<Tuple5<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5)));
    }

    default public Seq<Tuple6<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6)));
    }

    default public Seq<Tuple7<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7)));
    }

    default public Seq<Tuple8<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8)));
    }

    default public Seq<Tuple9<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9)));
    }

    default public Seq<Tuple10<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10)));
    }

    default public Seq<Tuple11<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11)));
    }

    default public Seq<Tuple12<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11, WindowSpecification<T> specification12) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        Map partitions12 = SeqUtils.partitions(specification12, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11), new WindowImpl(t, (List)partitions12.get(specification12.partition().apply(t.v1)), specification12)));
    }

    default public Seq<Tuple13<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11, WindowSpecification<T> specification12, WindowSpecification<T> specification13) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        Map partitions12 = SeqUtils.partitions(specification12, buffer);
        Map partitions13 = SeqUtils.partitions(specification13, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11), new WindowImpl(t, (List)partitions12.get(specification12.partition().apply(t.v1)), specification12), new WindowImpl(t, (List)partitions13.get(specification13.partition().apply(t.v1)), specification13)));
    }

    default public Seq<Tuple14<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11, WindowSpecification<T> specification12, WindowSpecification<T> specification13, WindowSpecification<T> specification14) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        Map partitions12 = SeqUtils.partitions(specification12, buffer);
        Map partitions13 = SeqUtils.partitions(specification13, buffer);
        Map partitions14 = SeqUtils.partitions(specification14, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11), new WindowImpl(t, (List)partitions12.get(specification12.partition().apply(t.v1)), specification12), new WindowImpl(t, (List)partitions13.get(specification13.partition().apply(t.v1)), specification13), new WindowImpl(t, (List)partitions14.get(specification14.partition().apply(t.v1)), specification14)));
    }

    default public Seq<Tuple15<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11, WindowSpecification<T> specification12, WindowSpecification<T> specification13, WindowSpecification<T> specification14, WindowSpecification<T> specification15) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        Map partitions12 = SeqUtils.partitions(specification12, buffer);
        Map partitions13 = SeqUtils.partitions(specification13, buffer);
        Map partitions14 = SeqUtils.partitions(specification14, buffer);
        Map partitions15 = SeqUtils.partitions(specification15, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11), new WindowImpl(t, (List)partitions12.get(specification12.partition().apply(t.v1)), specification12), new WindowImpl(t, (List)partitions13.get(specification13.partition().apply(t.v1)), specification13), new WindowImpl(t, (List)partitions14.get(specification14.partition().apply(t.v1)), specification14), new WindowImpl(t, (List)partitions15.get(specification15.partition().apply(t.v1)), specification15)));
    }

    default public Seq<Tuple16<Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>, Window<T>>> window(WindowSpecification<T> specification1, WindowSpecification<T> specification2, WindowSpecification<T> specification3, WindowSpecification<T> specification4, WindowSpecification<T> specification5, WindowSpecification<T> specification6, WindowSpecification<T> specification7, WindowSpecification<T> specification8, WindowSpecification<T> specification9, WindowSpecification<T> specification10, WindowSpecification<T> specification11, WindowSpecification<T> specification12, WindowSpecification<T> specification13, WindowSpecification<T> specification14, WindowSpecification<T> specification15, WindowSpecification<T> specification16) {
        List buffer = this.zipWithIndex().toList();
        Map partitions1 = SeqUtils.partitions(specification1, buffer);
        Map partitions2 = SeqUtils.partitions(specification2, buffer);
        Map partitions3 = SeqUtils.partitions(specification3, buffer);
        Map partitions4 = SeqUtils.partitions(specification4, buffer);
        Map partitions5 = SeqUtils.partitions(specification5, buffer);
        Map partitions6 = SeqUtils.partitions(specification6, buffer);
        Map partitions7 = SeqUtils.partitions(specification7, buffer);
        Map partitions8 = SeqUtils.partitions(specification8, buffer);
        Map partitions9 = SeqUtils.partitions(specification9, buffer);
        Map partitions10 = SeqUtils.partitions(specification10, buffer);
        Map partitions11 = SeqUtils.partitions(specification11, buffer);
        Map partitions12 = SeqUtils.partitions(specification12, buffer);
        Map partitions13 = SeqUtils.partitions(specification13, buffer);
        Map partitions14 = SeqUtils.partitions(specification14, buffer);
        Map partitions15 = SeqUtils.partitions(specification15, buffer);
        Map partitions16 = SeqUtils.partitions(specification16, buffer);
        return Seq.seq(buffer).map((T t) -> Tuple.tuple(new WindowImpl(t, (List)partitions1.get(specification1.partition().apply(t.v1)), specification1), new WindowImpl(t, (List)partitions2.get(specification2.partition().apply(t.v1)), specification2), new WindowImpl(t, (List)partitions3.get(specification3.partition().apply(t.v1)), specification3), new WindowImpl(t, (List)partitions4.get(specification4.partition().apply(t.v1)), specification4), new WindowImpl(t, (List)partitions5.get(specification5.partition().apply(t.v1)), specification5), new WindowImpl(t, (List)partitions6.get(specification6.partition().apply(t.v1)), specification6), new WindowImpl(t, (List)partitions7.get(specification7.partition().apply(t.v1)), specification7), new WindowImpl(t, (List)partitions8.get(specification8.partition().apply(t.v1)), specification8), new WindowImpl(t, (List)partitions9.get(specification9.partition().apply(t.v1)), specification9), new WindowImpl(t, (List)partitions10.get(specification10.partition().apply(t.v1)), specification10), new WindowImpl(t, (List)partitions11.get(specification11.partition().apply(t.v1)), specification11), new WindowImpl(t, (List)partitions12.get(specification12.partition().apply(t.v1)), specification12), new WindowImpl(t, (List)partitions13.get(specification13.partition().apply(t.v1)), specification13), new WindowImpl(t, (List)partitions14.get(specification14.partition().apply(t.v1)), specification14), new WindowImpl(t, (List)partitions15.get(specification15.partition().apply(t.v1)), specification15), new WindowImpl(t, (List)partitions16.get(specification16.partition().apply(t.v1)), specification16)));
    }

    default public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.collect(Collectors.groupingBy(classifier));
    }

    default public <K, A, D> Map<K, D> groupBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.collect(Collectors.groupingBy(classifier, downstream));
    }

    default public <K, D, A, M extends Map<K, D>> M groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return (M)((Map)this.collect(Collectors.groupingBy(classifier, mapFactory, downstream)));
    }

    @Deprecated
    default public String join() {
        return this.map(Objects::toString).collect(Collectors.joining());
    }

    @Deprecated
    default public String join(CharSequence delimiter) {
        return this.map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    @Deprecated
    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map(Objects::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static <T> Seq<T> of(T value) {
        return Seq.seq(Stream.of(value));
    }

    @SafeVarargs
    public static <T> Seq<T> of(T ... values) {
        return Seq.seq(Stream.of(values));
    }

    public static Seq<Byte> range(byte from, byte to) {
        return Seq.range(from, to, 1);
    }

    public static Seq<Byte> range(byte from, byte to, int step) {
        return to <= from ? Seq.empty() : Seq.iterate(from, t -> (byte)(t + step)).limitWhile(t -> t < to);
    }

    public static Seq<Short> range(short from, short to) {
        return Seq.range(from, to, 1);
    }

    public static Seq<Short> range(short from, short to, int step) {
        return to <= from ? Seq.empty() : Seq.iterate(from, t -> (short)(t + step)).limitWhile(t -> t < to);
    }

    public static Seq<Character> range(char from, char to) {
        return Seq.range(from, to, 1);
    }

    public static Seq<Character> range(char from, char to, int step) {
        return to <= from ? Seq.empty() : Seq.iterate(Character.valueOf(from), t -> Character.valueOf((char)(t.charValue() + step))).limitWhile(t -> t.charValue() < to);
    }

    public static Seq<Integer> range(int from, int to) {
        return Seq.range(from, to, 1);
    }

    public static Seq<Integer> range(int from, int to, int step) {
        return to <= from ? Seq.empty() : Seq.iterate(from, t -> t + step).limitWhile(t -> t < to);
    }

    public static Seq<Long> range(long from, long to) {
        return Seq.range(from, to, 1L);
    }

    public static Seq<Long> range(long from, long to, long step) {
        return to <= from ? Seq.empty() : Seq.iterate(from, t -> t + step).limitWhile(t -> t < to);
    }

    public static Seq<Instant> range(Instant from, Instant to) {
        return Seq.range(from, to, Duration.ofSeconds(1L));
    }

    public static Seq<Instant> range(Instant from, Instant to, Duration step) {
        return to.compareTo(from) <= 0 ? Seq.empty() : Seq.iterate(from, t -> t.plus(step)).limitWhile(t -> t.compareTo(to) < 0);
    }

    public static Seq<Byte> rangeClosed(byte from, byte to) {
        return Seq.rangeClosed(from, to, 1);
    }

    public static Seq<Byte> rangeClosed(byte from, byte to, int step) {
        return to < from ? Seq.empty() : Seq.iterate(from, t -> (byte)(t + step)).limitWhile(t -> t <= to);
    }

    public static Seq<Short> rangeClosed(short from, short to) {
        return Seq.rangeClosed(from, to, 1);
    }

    public static Seq<Short> rangeClosed(short from, short to, int step) {
        return to < from ? Seq.empty() : Seq.iterate(from, t -> (short)(t + step)).limitWhile(t -> t <= to);
    }

    public static Seq<Character> rangeClosed(char from, char to) {
        return Seq.rangeClosed(from, to, 1);
    }

    public static Seq<Character> rangeClosed(char from, char to, int step) {
        return to < from ? Seq.empty() : Seq.iterate(Character.valueOf(from), t -> Character.valueOf((char)(t.charValue() + step))).limitWhile(t -> t.charValue() <= to);
    }

    public static Seq<Integer> rangeClosed(int from, int to) {
        return Seq.rangeClosed(from, to, 1);
    }

    public static Seq<Integer> rangeClosed(int from, int to, int step) {
        return to < from ? Seq.empty() : Seq.iterate(from, t -> t + step).limitWhile(t -> t <= to);
    }

    public static Seq<Long> rangeClosed(long from, long to) {
        return Seq.rangeClosed(from, to, 1L);
    }

    public static Seq<Long> rangeClosed(long from, long to, long step) {
        return to < from ? Seq.empty() : Seq.iterate(from, t -> t + step).limitWhile(t -> t <= to);
    }

    public static Seq<Instant> rangeClosed(Instant from, Instant to) {
        return Seq.rangeClosed(from, to, Duration.ofSeconds(1L));
    }

    public static Seq<Instant> rangeClosed(Instant from, Instant to, Duration step) {
        return to.compareTo(from) < 0 ? Seq.empty() : Seq.iterate(from, t -> t.plus(step)).limitWhile(t -> t.compareTo(to) <= 0);
    }

    public static <T> Seq<T> empty() {
        return Seq.seq(Stream.empty());
    }

    public static <T> Seq<T> iterate(T seed, UnaryOperator<T> f) {
        return Seq.seq(Stream.iterate(seed, f));
    }

    public static Seq<Void> generate() {
        return Seq.generate(() -> null);
    }

    public static <T> Seq<T> generate(T value) {
        return Seq.generate(() -> value);
    }

    public static <T> Seq<T> generate(Supplier<T> s) {
        return Seq.seq(Stream.generate(s));
    }

    public static <T> Seq<T> seq(Stream<T> stream) {
        if (stream instanceof Seq) {
            return (Seq)stream;
        }
        return new SeqImpl<T>(stream);
    }

    public static <T> Seq<T> seq(Seq<T> stream) {
        return stream;
    }

    public static Seq<Integer> seq(IntStream stream) {
        return new SeqImpl<Integer>(stream.boxed());
    }

    public static Seq<Long> seq(LongStream stream) {
        return new SeqImpl<Long>(stream.boxed());
    }

    public static Seq<Double> seq(DoubleStream stream) {
        return new SeqImpl<Double>(stream.boxed());
    }

    public static <T> Seq<T> seq(Iterable<T> iterable) {
        return Seq.seq(iterable.iterator());
    }

    public static <T> Seq<T> seq(Iterator<T> iterator) {
        return Seq.seq(Spliterators.spliteratorUnknownSize(iterator, 16));
    }

    public static <T> Seq<T> seq(Spliterator<T> spliterator) {
        return Seq.seq(StreamSupport.stream(spliterator, false));
    }

    public static <K, V> Seq<Tuple2<K, V>> seq(Map<K, V> map) {
        return Seq.seq(map.entrySet()).map((T e) -> Tuple.tuple(e.getKey(), e.getValue()));
    }

    public static <T> Seq<T> seq(Optional<T> optional) {
        return optional.map(Seq::of).orElseGet(Seq::empty);
    }

    public static Seq<Byte> seq(InputStream is) {
        FunctionalSpliterator spliterator = consumer -> {
            try {
                int value = is.read();
                if (value != -1) {
                    consumer.accept((byte)value);
                }
                return value != -1;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return Seq.seq(spliterator).onClose(Unchecked.runnable(is::close));
    }

    public static Seq<Character> seq(Reader reader) {
        FunctionalSpliterator spliterator = consumer -> {
            try {
                int value = reader.read();
                if (value != -1) {
                    consumer.accept(Character.valueOf((char)value));
                }
                return value != -1;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return Seq.seq(spliterator).onClose(Unchecked.runnable(reader::close));
    }

    public static <T> Seq<T> cycle(Stream<T> stream) {
        return Seq.cycle(Seq.seq(stream));
    }

    public static <T> Seq<T> cycle(Iterable<T> iterable) {
        return Seq.cycle(Seq.seq(iterable));
    }

    public static <T> Seq<T> cycle(Seq<T> stream) {
        ArrayList list = new ArrayList();
        Spliterator[] sp = new Spliterator[1];
        return SeqUtils.transform(stream, (delegate, action) -> {
            if (sp[0] == null) {
                if (delegate.tryAdvance(t -> {
                    list.add(t);
                    action.accept(t);
                })) {
                    return true;
                }
                sp[0] = list.spliterator();
            }
            if (!sp[0].tryAdvance(action)) {
                sp[0] = list.spliterator();
                if (!sp[0].tryAdvance(action)) {
                    return false;
                }
            }
            return true;
        });
    }

    public static <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(Stream<Tuple2<T1, T2>> stream) {
        return Seq.unzip(Seq.seq(stream));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, Function<T1, U1> leftUnzipper, Function<T2, U2> rightUnzipper) {
        return Seq.unzip(Seq.seq(stream), leftUnzipper, rightUnzipper);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, Function<Tuple2<T1, T2>, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(Seq.seq(stream), unzipper);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, BiFunction<T1, T2, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(Seq.seq(stream), unzipper);
    }

    public static <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(Iterable<Tuple2<T1, T2>> iterable) {
        return Seq.unzip(Seq.seq(iterable));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Iterable<Tuple2<T1, T2>> iterable, Function<T1, U1> leftUnzipper, Function<T2, U2> rightUnzipper) {
        return Seq.unzip(Seq.seq(iterable), leftUnzipper, rightUnzipper);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Iterable<Tuple2<T1, T2>> iterable, Function<Tuple2<T1, T2>, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(Seq.seq(iterable), unzipper);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Iterable<Tuple2<T1, T2>> iterable, BiFunction<T1, T2, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(Seq.seq(iterable), unzipper);
    }

    public static <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(Seq<Tuple2<T1, T2>> stream) {
        return Seq.unzip(stream, (Tuple2<T1, T2> t) -> t);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Seq<Tuple2<T1, T2>> stream, Function<T1, U1> leftUnzipper, Function<T2, U2> rightUnzipper) {
        return Seq.unzip(stream, (Tuple2<T1, T2> t) -> Tuple.tuple(leftUnzipper.apply(t.v1), rightUnzipper.apply(t.v2)));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Seq<Tuple2<T1, T2>> stream, Function<Tuple2<T1, T2>, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(stream, (T1 t1, T2 t2) -> (Tuple2)unzipper.apply(Tuple.tuple(t1, t2)));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Seq<Tuple2<T1, T2>> stream, BiFunction<T1, T2, Tuple2<U1, U2>> unzipper) {
        return stream.map((T t) -> (Tuple2)unzipper.apply(t.v1, t.v2)).duplicate().map1(s -> s.map((T u) -> u.v1)).map2(s -> s.map((T u) -> u.v2));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> zip(Stream<T1> s1, Stream<T2> s2) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15, Stream<T16> s16) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15), Seq.seq(s16));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> zip(Iterable<T1> i1, Iterable<T2> i2) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15, Iterable<T16> i16) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15), Seq.seq(i16));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> zip(Seq<T1> s1, Seq<T2> s2) {
        return Seq.zip(s1, s2, (? super T1 t1, ? super T2 t2) -> Tuple.tuple(t1, t2));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3) {
        return Seq.zip(s1, s2, s3, (? super T1 t1, ? super T2 t2, ? super T3 t3) -> Tuple.tuple(t1, t2, t3));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4) {
        return Seq.zip(s1, s2, s3, s4, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4) -> Tuple.tuple(t1, t2, t3, t4));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5) {
        return Seq.zip(s1, s2, s3, s4, s5, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5) -> Tuple.tuple(t1, t2, t3, t4, t5));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6) -> Tuple.tuple(t1, t2, t3, t4, t5, t6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11, ? super T12 t12) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11, ? super T12 t12, ? super T13 t13) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11, ? super T12 t12, ? super T13 t13, ? super T14 t14) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11, ? super T12 t12, ? super T13 t13, ? super T14 t14, ? super T15 t15) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15, Seq<T16> s16) {
        return Seq.zip(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, (? super T1 t1, ? super T2 t2, ? super T3 t3, ? super T4 t4, ? super T5 t5, ? super T6 t6, ? super T7 t7, ? super T8 t8, ? super T9 t9, ? super T10 t10, ? super T11 t11, ? super T12 t12, ? super T13 t13, ? super T14 t14, ? super T15 t15, ? super T16 t16) -> Tuple.tuple(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16));
    }

    public static <T1, T2, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), zipper);
    }

    public static <T1, T2, T3, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), zipper);
    }

    public static <T1, T2, T3, T4, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), zipper);
    }

    public static <T1, T2, T3, T4, T5, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Function10<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Function11<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Function12<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Function13<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Function14<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15, Function15<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R> Seq<R> zip(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15, Stream<T16> s16, Function16<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? super T16, ? extends R> zipper) {
        return Seq.zip(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15), Seq.seq(s16), zipper);
    }

    public static <T1, T2, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), zipper);
    }

    public static <T1, T2, T3, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), zipper);
    }

    public static <T1, T2, T3, T4, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), zipper);
    }

    public static <T1, T2, T3, T4, T5, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Function10<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Function11<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Function12<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Function13<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Function14<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15, Function15<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15), zipper);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R> Seq<R> zip(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15, Iterable<T16> i16, Function16<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? super T16, ? extends R> zipper) {
        return Seq.zip(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15), Seq.seq(i16), zipper);
    }

    public static <T1, T2, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, final BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, final Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, final Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, final Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, final Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, final Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, final Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, final Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, final Function10<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, final Function11<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, final Function12<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        final Iterator it12 = s12.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext() && it12.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next(), it12.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, final Function13<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        final Iterator it12 = s12.iterator();
        final Iterator it13 = s13.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext() && it12.hasNext() && it13.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next(), it12.next(), it13.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, final Function14<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        final Iterator it12 = s12.iterator();
        final Iterator it13 = s13.iterator();
        final Iterator it14 = s14.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext() && it12.hasNext() && it13.hasNext() && it14.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next(), it12.next(), it13.next(), it14.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15, final Function15<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        final Iterator it12 = s12.iterator();
        final Iterator it13 = s13.iterator();
        final Iterator it14 = s14.iterator();
        final Iterator it15 = s15.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext() && it12.hasNext() && it13.hasNext() && it14.hasNext() && it15.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next(), it12.next(), it13.next(), it14.next(), it15.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R> Seq<R> zip(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15, Seq<T16> s16, final Function16<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? super T10, ? super T11, ? super T12, ? super T13, ? super T14, ? super T15, ? super T16, ? extends R> zipper) {
        final Iterator it1 = s1.iterator();
        final Iterator it2 = s2.iterator();
        final Iterator it3 = s3.iterator();
        final Iterator it4 = s4.iterator();
        final Iterator it5 = s5.iterator();
        final Iterator it6 = s6.iterator();
        final Iterator it7 = s7.iterator();
        final Iterator it8 = s8.iterator();
        final Iterator it9 = s9.iterator();
        final Iterator it10 = s10.iterator();
        final Iterator it11 = s11.iterator();
        final Iterator it12 = s12.iterator();
        final Iterator it13 = s13.iterator();
        final Iterator it14 = s14.iterator();
        final Iterator it15 = s15.iterator();
        final Iterator it16 = s16.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext() && it3.hasNext() && it4.hasNext() && it5.hasNext() && it6.hasNext() && it7.hasNext() && it8.hasNext() && it9.hasNext() && it10.hasNext() && it11.hasNext() && it12.hasNext() && it13.hasNext() && it14.hasNext() && it15.hasNext() && it16.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next(), it3.next(), it4.next(), it5.next(), it6.next(), it7.next(), it8.next(), it9.next(), it10.next(), it11.next(), it12.next(), it13.next(), it14.next(), it15.next(), it16.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T> Seq<Tuple2<T, Long>> zipWithIndex(Stream<T> stream) {
        return Seq.zipWithIndex(Seq.seq(stream));
    }

    public static <T> Seq<Tuple2<T, Long>> zipWithIndex(Iterable<T> iterable) {
        return Seq.zipWithIndex(Seq.seq(iterable));
    }

    public static <T> Seq<Tuple2<T, Long>> zipWithIndex(Seq<T> stream) {
        long[] index = new long[]{-1L};
        return SeqUtils.transform(stream, (delegate, action) -> delegate.tryAdvance(t -> {
            index[0] = index[0] + 1L;
            action.accept(Tuple.tuple(t, index[0]));
        }));
    }

    public static <T, U> U foldLeft(Stream<T> stream, U seed, BiFunction<U, ? super T, U> function) {
        return Seq.foldLeft(Seq.seq(stream), seed, function);
    }

    public static <T, U> U foldLeft(Iterable<T> iterable, U seed, BiFunction<U, ? super T, U> function) {
        return Seq.foldLeft(Seq.seq(iterable), seed, function);
    }

    public static <T, U> U foldLeft(Seq<T> stream, U seed, BiFunction<U, ? super T, U> function) {
        Iterator it = stream.iterator();
        U result = seed;
        while (it.hasNext()) {
            result = function.apply(result, it.next());
        }
        return result;
    }

    public static <T, U> U foldRight(Stream<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return Seq.foldRight(Seq.seq(stream), seed, function);
    }

    public static <T, U> U foldRight(Iterable<T> iterable, U seed, BiFunction<? super T, U, U> function) {
        return Seq.foldRight(Seq.seq(iterable), seed, function);
    }

    public static <T, U> U foldRight(Seq<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return (U)stream.reverse().foldLeft(seed, (u, t) -> function.apply(t, u));
    }

    public static <T, U> Seq<U> scanLeft(Stream<T> stream, U seed, BiFunction<U, ? super T, U> function) {
        return Seq.scanLeft(Seq.seq(stream), seed, function);
    }

    public static <T, U> Seq<U> scanLeft(Iterable<T> iterable, U seed, BiFunction<U, ? super T, U> function) {
        return Seq.scanLeft(Seq.seq(iterable), seed, function);
    }

    public static <T, U> Seq<U> scanLeft(Seq<T> stream, U seed, BiFunction<U, ? super T, U> function) {
        Object[] value = new Object[]{seed};
        return Seq.of(seed).concat((U)SeqUtils.transform(stream, (delegate, action) -> delegate.tryAdvance(t -> {
            value[0] = function.apply(value[0], t);
            action.accept(value[0]);
        })));
    }

    public static <T, U> Seq<U> scanRight(Stream<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return Seq.scanRight(Seq.seq(stream), seed, function);
    }

    public static <T, U> Seq<U> scanRight(Iterable<T> iterable, U seed, BiFunction<? super T, U, U> function) {
        return Seq.scanRight(Seq.seq(iterable), seed, function);
    }

    public static <T, U> Seq<U> scanRight(Seq<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return stream.reverse().scanLeft(seed, (u, t) -> function.apply(t, u));
    }

    public static <T, U> Seq<T> unfold(U seed, Function<U, Optional<Tuple2<T, U>>> unfolder) {
        Tuple2[] unfolded = new Tuple2[]{Tuple.tuple(null, seed)};
        return Seq.seq(action -> {
            Optional result = (Optional)unfolder.apply(unfolded[0].v2);
            if (result.isPresent()) {
                unfolded[0] = (Tuple2)result.get();
                action.accept(unfolded[0].v1);
            }
            return result.isPresent();
        });
    }

    public static <T> Seq<T> reverse(Stream<T> stream) {
        return Seq.reverse(Seq.seq(stream));
    }

    public static <T> Seq<T> reverse(Iterable<T> iterable) {
        return Seq.reverse(Seq.seq(iterable));
    }

    public static <T> Seq<T> reverse(Seq<T> stream) {
        List<T> list = Seq.toList(stream);
        Collections.reverse(list);
        return Seq.seq(list);
    }

    public static <T> Seq<T> shuffle(Stream<T> stream) {
        return Seq.shuffle(Seq.seq(stream));
    }

    public static <T> Seq<T> shuffle(Iterable<T> iterable) {
        return Seq.shuffle(Seq.seq(iterable));
    }

    public static <T> Seq<T> shuffle(Seq<T> stream) {
        List<T> list = Seq.toList(stream);
        Collections.shuffle(list);
        return Seq.seq(list);
    }

    public static <T> Seq<T> shuffle(Stream<T> stream, Random random) {
        return Seq.shuffle(Seq.seq(stream), random);
    }

    public static <T> Seq<T> shuffle(Iterable<T> iterable, Random random) {
        return Seq.shuffle(Seq.seq(iterable), random);
    }

    public static <T> Seq<T> shuffle(Seq<T> stream, Random random) {
        List<T> list = Seq.toList(stream);
        Collections.shuffle(list, random);
        return Seq.seq(list);
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> crossJoin(Stream<T1> s1, Stream<T2> s2) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> crossJoin(Stream<T1> s1, Stream<T2> s2, Stream<T3> s3, Stream<T4> s4, Stream<T5> s5, Stream<T6> s6, Stream<T7> s7, Stream<T8> s8, Stream<T9> s9, Stream<T10> s10, Stream<T11> s11, Stream<T12> s12, Stream<T13> s13, Stream<T14> s14, Stream<T15> s15, Stream<T16> s16) {
        return Seq.crossJoin(Seq.seq(s1), Seq.seq(s2), Seq.seq(s3), Seq.seq(s4), Seq.seq(s5), Seq.seq(s6), Seq.seq(s7), Seq.seq(s8), Seq.seq(s9), Seq.seq(s10), Seq.seq(s11), Seq.seq(s12), Seq.seq(s13), Seq.seq(s14), Seq.seq(s15), Seq.seq(s16));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> crossJoin(Iterable<T1> i1, Iterable<T2> i2) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> crossJoin(Iterable<T1> i1, Iterable<T2> i2, Iterable<T3> i3, Iterable<T4> i4, Iterable<T5> i5, Iterable<T6> i6, Iterable<T7> i7, Iterable<T8> i8, Iterable<T9> i9, Iterable<T10> i10, Iterable<T11> i11, Iterable<T12> i12, Iterable<T13> i13, Iterable<T14> i14, Iterable<T15> i15, Iterable<T16> i16) {
        return Seq.crossJoin(Seq.seq(i1), Seq.seq(i2), Seq.seq(i3), Seq.seq(i4), Seq.seq(i5), Seq.seq(i6), Seq.seq(i7), Seq.seq(i8), Seq.seq(i9), Seq.seq(i10), Seq.seq(i11), Seq.seq(i12), Seq.seq(i13), Seq.seq(i14), Seq.seq(i15), Seq.seq(i16));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> crossJoin(Seq<T1> s1, Seq<T2> s2) {
        List list = s2.toList();
        return Seq.seq(s1).flatMap((T v1) -> Seq.seq(list).map(v2 -> Tuple.tuple(v1, v2)));
    }

    public static <T1, T2, T3> Seq<Tuple3<T1, T2, T3>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3) {
        List list = Seq.crossJoin(s2, s3).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2)));
    }

    public static <T1, T2, T3, T4> Seq<Tuple4<T1, T2, T3, T4>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4) {
        List list = Seq.crossJoin(s2, s3, s4).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3)));
    }

    public static <T1, T2, T3, T4, T5> Seq<Tuple5<T1, T2, T3, T4, T5>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5) {
        List list = Seq.crossJoin(s2, s3, s4, s5).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4)));
    }

    public static <T1, T2, T3, T4, T5, T6> Seq<Tuple6<T1, T2, T3, T4, T5, T6>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Seq<Tuple7<T1, T2, T3, T4, T5, T6, T7>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Seq<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Seq<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Seq<Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Seq<Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Seq<Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10, t.v11)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Seq<Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10, t.v11, t.v12)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Seq<Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10, t.v11, t.v12, t.v13)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Seq<Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10, t.v11, t.v12, t.v13, t.v14)));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Seq<Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> crossJoin(Seq<T1> s1, Seq<T2> s2, Seq<T3> s3, Seq<T4> s4, Seq<T5> s5, Seq<T6> s6, Seq<T7> s7, Seq<T8> s8, Seq<T9> s9, Seq<T10> s10, Seq<T11> s11, Seq<T12> s12, Seq<T13> s13, Seq<T14> s14, Seq<T15> s15, Seq<T16> s16) {
        List list = Seq.crossJoin(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16).toList();
        return s1.flatMap((T v1) -> Seq.seq(list).map(t -> Tuple.tuple(v1, t.v1, t.v2, t.v3, t.v4, t.v5, t.v6, t.v7, t.v8, t.v9, t.v10, t.v11, t.v12, t.v13, t.v14, t.v15)));
    }

    @SafeVarargs
    public static <T> Seq<T> concat(Stream<T> ... streams) {
        return Seq.concat(SeqUtils.seqs(streams));
    }

    @SafeVarargs
    public static <T> Seq<T> concat(Iterable<T> ... iterables) {
        return Seq.concat(SeqUtils.seqs(iterables));
    }

    @SafeVarargs
    public static <T> Seq<T> concat(Seq<T> ... streams) {
        if (streams == null || streams.length == 0) {
            return Seq.empty();
        }
        if (streams.length == 1) {
            return Seq.seq(streams[0]);
        }
        Stream<T> result = streams[0];
        for (int i = 1; i < streams.length; ++i) {
            result = Stream.concat(result, streams[i]);
        }
        return Seq.seq(result);
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> duplicate(Stream<T> stream) {
        final LinkedList gap = new LinkedList();
        final Iterator it = stream.iterator();
        final Iterator[] ahead = new Iterator[]{null};
        class Duplicate
        implements Iterator<T> {
            Duplicate() {
            }

            @Override
            public boolean hasNext() {
                if (ahead[0] == null || ahead[0] == this) {
                    return it.hasNext();
                }
                return !gap.isEmpty();
            }

            @Override
            public T next() {
                if (ahead[0] == null) {
                    ahead[0] = this;
                }
                if (ahead[0] == this) {
                    Object value = it.next();
                    gap.offer(value);
                    return value;
                }
                Object value = gap.poll();
                if (gap.isEmpty()) {
                    ahead[0] = null;
                }
                return value;
            }
        }
        return Tuple.tuple(Seq.seq(new Duplicate()), Seq.seq(new Duplicate()));
    }

    public static String toString(Stream<?> stream) {
        return Seq.toString(stream, "");
    }

    public static String toString(Stream<?> stream, CharSequence delimiter) {
        return stream.map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    public static <T, C extends Collection<T>> C toCollection(Stream<T> stream, Supplier<C> collectionFactory) {
        return (C)((Collection)stream.collect(Collectors.toCollection(collectionFactory)));
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <T, K, V> Map<K, V> toMap(Stream<Tuple2<K, V>> stream) {
        return stream.collect(Collectors.toMap(Tuple2::v1, Tuple2::v2));
    }

    public static <T, K, V> Map<K, V> toMap(Stream<T> stream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return stream.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T> Seq<T> slice(Stream<T> stream, long from, long to) {
        long f = Math.max(from, 0L);
        long t = Math.max(to - f, 0L);
        return Seq.seq(stream.skip(f).limit(t));
    }

    public static <T> Seq<T> skip(Stream<T> stream, long elements) {
        return Seq.seq(stream.skip(elements));
    }

    public static <T> Seq<T> skipWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.skipUntil(stream, predicate.negate());
    }

    public static <T> Seq<T> skipWhileClosed(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.skipUntilClosed(stream, predicate.negate());
    }

    public static <T> Seq<T> skipUntil(Stream<T> stream, Predicate<? super T> predicate) {
        boolean[] test = new boolean[]{false};
        return SeqUtils.transform(stream, (delegate, action) -> !test[0] ? delegate.tryAdvance(t -> {
            test[0] = predicate.test(t);
            if (test[0]) {
                action.accept(t);
            }
        }) : delegate.tryAdvance(action));
    }

    public static <T> Seq<T> skipUntilClosed(Stream<T> stream, Predicate<? super T> predicate) {
        boolean[] test = new boolean[]{false};
        return SeqUtils.transform(stream, (delegate, action) -> !test[0] ? delegate.tryAdvance(t -> {
            test[0] = predicate.test(t);
        }) : delegate.tryAdvance(action));
    }

    public static <T> Seq<T> limit(Stream<T> stream, long elements) {
        return Seq.seq(stream.limit(elements));
    }

    public static <T> Seq<T> limitWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.limitUntil(stream, predicate.negate());
    }

    public static <T> Seq<T> limitWhileClosed(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.limitUntilClosed(stream, predicate.negate());
    }

    public static <T> Seq<T> limitUntil(Stream<T> stream, Predicate<? super T> predicate) {
        boolean[] test = new boolean[]{false};
        return SeqUtils.transform(stream, (delegate, action) -> delegate.tryAdvance(t -> {
            test[0] = predicate.test(t);
            if (!test[0]) {
                action.accept(t);
            }
        }) && !test[0]);
    }

    public static <T> Seq<T> limitUntilClosed(Stream<T> stream, Predicate<? super T> predicate) {
        boolean[] test = new boolean[]{false};
        return SeqUtils.transform(stream, (delegate, action) -> !test[0] && delegate.tryAdvance(t -> {
            test[0] = predicate.test(t);
            action.accept(t);
        }));
    }

    public static <T> Seq<T> intersperse(Stream<T> stream, T value) {
        return Seq.seq(stream.flatMap((? super T t) -> Stream.of(value, t)).skip(1L));
    }

    public static <K, T> Seq<Tuple2<K, Seq<T>>> grouped(Stream<T> stream, Function<? super T, ? extends K> classifier) {
        return Seq.grouped(Seq.seq(stream), classifier);
    }

    public static <K, T> Seq<Tuple2<K, Seq<T>>> grouped(Iterable<T> iterable, Function<? super T, ? extends K> classifier) {
        return Seq.grouped(Seq.seq(iterable), classifier);
    }

    public static <K, T> Seq<Tuple2<K, Seq<T>>> grouped(Seq<T> seq, final Function<? super T, ? extends K> classifier) {
        final Iterator it = seq.iterator();
        class ClassifyingIterator
        implements Iterator<Tuple2<K, Seq<T>>> {
            final Map<K, Queue<T>> buffers = new LinkedHashMap();
            final Queue<K> keys = new LinkedList();

            ClassifyingIterator() {
            }

            void fetchClassifying() {
                while (it.hasNext() && this.fetchNextNewKey()) {
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean fetchNextNewKey() {
                Object next = it.next();
                Object nextK = classifier.apply(next);
                Queue buffer = this.buffers.get(nextK);
                try {
                    if (buffer == null) {
                        buffer = new ArrayDeque();
                        this.buffers.put(nextK, buffer);
                        this.keys.add(nextK);
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    buffer.offer(next);
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                this.fetchClassifying();
                return !this.keys.isEmpty();
            }

            @Override
            public Tuple2<K, Seq<T>> next() {
                Object nextK = this.keys.poll();
                return Tuple.tuple(nextK, Seq.seq(new 1ClassifyingIterator.Classification(nextK)));
            }

            class 1ClassifyingIterator.Classification
            implements Iterator<T> {
                final K key;
                Queue<T> buffer;

                1ClassifyingIterator.Classification(K key) {
                    this.key = key;
                }

                void fetchClassification() {
                    if (this.buffer == null) {
                        this.buffer = buffers.get(this.key);
                    }
                    while (this.buffer.isEmpty() && it.hasNext()) {
                        this.fetchNextNewKey();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.fetchClassification();
                    return !this.buffer.isEmpty();
                }

                @Override
                public T next() {
                    return this.buffer.poll();
                }
            }
        }
        return Seq.seq(new ClassifyingIterator());
    }

    public static <K, T, A, D> Seq<Tuple2<K, D>> grouped(Stream<T> stream, Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.grouped(Seq.seq(stream), classifier, downstream);
    }

    public static <K, T, A, D> Seq<Tuple2<K, D>> grouped(Iterable<T> iterable, Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.grouped(Seq.seq(iterable), classifier, downstream);
    }

    public static <K, T, A, D> Seq<Tuple2<K, D>> grouped(Seq<T> seq, Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.grouped(seq, classifier).map((T t) -> Tuple.tuple(t.v1, ((Seq)t.v2).collect(downstream)));
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> partition(Stream<T> stream, final Predicate<? super T> predicate) {
        final Iterator it = stream.iterator();
        final LinkedList buffer1 = new LinkedList();
        final LinkedList buffer2 = new LinkedList();
        class Partition
        implements Iterator<T> {
            final boolean b;

            Partition(boolean b) {
                this.b = b;
            }

            void fetch() {
                while (this.buffer(this.b).isEmpty() && it.hasNext()) {
                    Object next = it.next();
                    this.buffer(predicate.test(next)).offer(next);
                }
            }

            LinkedList<T> buffer(boolean test) {
                return test ? buffer1 : buffer2;
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return !this.buffer(this.b).isEmpty();
            }

            @Override
            public T next() {
                return this.buffer(this.b).poll();
            }
        }
        return Tuple.tuple(Seq.seq(new Partition(true)), Seq.seq(new Partition(false)));
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> splitAt(Stream<T> stream, long position) {
        return Seq.seq(stream).zipWithIndex().partition(t -> (Long)t.v2 < position).map((T1 v1, T2 v2) -> Tuple.tuple(v1.map((T t) -> t.v1), v2.map((T t) -> t.v1)));
    }

    public static <T> Tuple2<Optional<T>, Seq<T>> splitAtHead(Stream<T> stream) {
        Iterator it = stream.iterator();
        return Tuple.tuple(it.hasNext() ? Optional.of(it.next()) : Optional.empty(), Seq.seq(it));
    }

    public static <T, U> Seq<U> ofType(Stream<T> stream, Class<U> type) {
        return Seq.seq(stream).filter(type::isInstance).map((T t) -> t);
    }

    public static <T, U> Seq<U> cast(Stream<T> stream, Class<U> type) {
        return Seq.seq(stream).map(type::cast);
    }

    public static <T, K> Map<K, List<T>> groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier) {
        return Seq.seq(stream).groupBy(classifier);
    }

    public static <T, K, A, D> Map<K, D> groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.seq(stream).groupBy(classifier, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> M groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return Seq.seq(stream).groupBy(classifier, mapFactory, downstream);
    }

    @Deprecated
    public static String join(Stream<?> stream) {
        return Seq.seq(stream).join();
    }

    @Deprecated
    public static String join(Stream<?> stream, CharSequence delimiter) {
        return Seq.seq(stream).join(delimiter);
    }

    @Deprecated
    public static String join(Stream<?> stream, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Seq.seq(stream).join(delimiter, prefix, suffix);
    }

    @Override
    public Seq<T> filter(Predicate<? super T> var1);

    @Override
    public <R> Seq<R> map(Function<? super T, ? extends R> var1);

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public <R> Seq<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public Seq<T> distinct();

    @Override
    public Seq<T> sorted();

    @Override
    public Seq<T> sorted(Comparator<? super T> var1);

    @Override
    public Seq<T> peek(Consumer<? super T> var1);

    @Override
    public Seq<T> limit(long var1);

    @Override
    public Seq<T> skip(long var1);

    @Override
    public Seq<T> onClose(Runnable var1);

    @Override
    public void close();

    @Override
    public long count();

    @Override
    default public Seq<T> sequential() {
        return this;
    }

    @Override
    default public Seq<T> parallel() {
        return this;
    }

    @Override
    default public Seq<T> unordered() {
        return this;
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Iterable.super.spliterator();
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Iterable.super.forEach(action);
    }

    public String format();

    default public void printOut() {
        this.print(System.out);
    }

    default public void printErr() {
        this.print(System.err);
    }

    default public void print(PrintWriter writer) {
        this.forEach(writer::println);
    }

    default public void print(PrintStream stream) {
        this.forEach(stream::println);
    }
}

