/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Sets;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.$AutoValue_Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog2.shared.metrics.MetricUtils;

@AutoValue
public abstract class Pipeline {
    private String metricName;
    private transient Meter executed;

    @Nullable
    public abstract String id();

    public abstract String name();

    public abstract SortedSet<Stage> stages();

    public static Builder builder() {
        return new $AutoValue_Pipeline.Builder();
    }

    public static Pipeline empty(String name) {
        return Pipeline.builder().name(name).stages(Sets.newTreeSet()).build();
    }

    public abstract Builder toBuilder();

    public Pipeline withId(String id) {
        return this.toBuilder().id(id).build();
    }

    public abstract int hashCode();

    public void registerMetrics(MetricRegistry metricRegistry) {
        if (this.id() != null) {
            this.metricName = MetricRegistry.name(Pipeline.class, (String[])new String[]{this.id(), "executed"});
            this.executed = metricRegistry.meter(this.metricName);
        }
    }

    public MetricFilter metricsFilter() {
        if (this.id() == null) {
            return (name, metric) -> false;
        }
        return new MetricUtils.SingleMetricFilter(this.metricName);
    }

    public void markExecution() {
        if (this.executed != null) {
            this.executed.mark();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pipeline ");
        sb.append("'").append(this.name()).append("'");
        sb.append(" (").append(this.id()).append(")");
        return sb.toString();
    }

    public static abstract class Builder {
        public abstract Pipeline build();

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder stages(SortedSet<Stage> var1);
    }
}

