/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.lambda;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jooq.lambda.Agg;
import org.jooq.lambda.Seq;
import org.jooq.lambda.Window;
import org.jooq.lambda.WindowSpecification;
import org.jooq.lambda.tuple.Tuple2;

class WindowImpl<T>
implements Window<T> {
    final Tuple2<T, Long> value;
    final int index;
    final List<Tuple2<T, Long>> partition;
    final Comparator<? super T> order;
    final long lower;
    final long upper;

    WindowImpl(Tuple2<T, Long> value, List<Tuple2<T, Long>> partition, WindowSpecification<T> specification) {
        this.value = value;
        this.index = partition.indexOf(value);
        this.partition = partition;
        this.order = specification.order().orElse(Comparator.naturalOrder());
        this.lower = specification.lower();
        this.upper = specification.upper();
    }

    @Override
    public T value() {
        return (T)this.value.v1;
    }

    @Override
    public Seq<T> window() {
        return Seq.seq(this.partition.subList(this.lower(), this.upper() + 1)).map(t -> t.v1);
    }

    private int lower() {
        return this.lower == Long.MIN_VALUE ? 0 : (int)Math.max(0L, (long)this.index + this.lower);
    }

    private boolean lowerInPartition() {
        return this.lower == Long.MIN_VALUE || (long)this.index + this.lower >= 0L && (long)this.index + this.lower < (long)this.partition.size();
    }

    private int upper() {
        return this.upper == Long.MAX_VALUE ? this.partition.size() - 1 : (int)Math.min((long)(this.partition.size() - 1), (long)this.index + this.upper);
    }

    private boolean upperInPartition() {
        return this.upper == Long.MAX_VALUE || (long)this.index + this.upper >= 0L && (long)this.index + this.upper < (long)this.partition.size();
    }

    @Override
    public long rowNumber() {
        return this.index;
    }

    @Override
    public long rank() {
        return Seq.seq(this.partition).map(t -> t.v1).collect(Agg.rank(this.value.v1, this.order)).get();
    }

    @Override
    public long denseRank() {
        return Seq.seq(this.partition).map(t -> t.v1).collect(Agg.denseRank(this.value.v1, this.order)).get();
    }

    @Override
    public double percentRank() {
        return (double)this.rank() / (double)(this.partition.size() - 1);
    }

    @Override
    public long ntile(long bucket) {
        return bucket * this.rowNumber() / (long)this.partition.size();
    }

    @Override
    public Optional<T> lead() {
        return this.lead(1L);
    }

    @Override
    public Optional<T> lead(long lead) {
        return this.lead0(lead);
    }

    @Override
    public Optional<T> lag() {
        return this.lag(1L);
    }

    @Override
    public Optional<T> lag(long lag) {
        return this.lead0(-lag);
    }

    private Optional<T> lead0(long lead) {
        if (lead == 0L) {
            return Optional.of(this.value.v1);
        }
        if ((long)this.index + lead >= 0L && (long)this.index + lead < (long)this.partition.size()) {
            return Optional.of(this.partition.get((int)(this.index + (int)lead)).v1);
        }
        return Optional.empty();
    }

    @Override
    public Optional<T> firstValue() {
        return this.firstValue(t -> t);
    }

    @Override
    public <U> Optional<U> firstValue(Function<? super T, ? extends U> function) {
        return this.lowerInPartition() ? Optional.of(function.apply(this.partition.get((int)this.lower()).v1)) : (this.upperInPartition() ? Optional.of(function.apply(this.partition.get((int)0).v1)) : Optional.empty());
    }

    @Override
    public Optional<T> lastValue() {
        return this.lastValue(t -> t);
    }

    @Override
    public <U> Optional<U> lastValue(Function<? super T, ? extends U> function) {
        return this.upperInPartition() ? Optional.of(function.apply(this.partition.get((int)this.upper()).v1)) : (this.lowerInPartition() ? Optional.of(function.apply(this.partition.get((int)(this.partition.size() - 1)).v1)) : Optional.empty());
    }

    @Override
    public Optional<T> nthValue(long n) {
        return this.nthValue(n, t -> t);
    }

    @Override
    public <U> Optional<U> nthValue(long n, Function<? super T, ? extends U> function) {
        return (long)this.lower() + n <= (long)this.upper() ? Optional.of(function.apply(this.partition.get((int)(this.lower() + (int)n)).v1)) : Optional.empty();
    }

    @Override
    public long count() {
        return 1 + this.upper() - this.lower();
    }

    @Override
    public long countDistinct() {
        return this.window().countDistinct();
    }

    @Override
    public <U> long countDistinctBy(Function<? super T, ? extends U> function) {
        return this.window().countDistinctBy(function);
    }

    @Override
    public Optional<T> sum() {
        return this.window().sum();
    }

    @Override
    public <U> Optional<U> sum(Function<? super T, ? extends U> function) {
        return this.window().sum(function);
    }

    @Override
    public int sumInt(ToIntFunction<? super T> function) {
        return this.window().sumInt(function);
    }

    @Override
    public long sumLong(ToLongFunction<? super T> function) {
        return this.window().sumLong(function);
    }

    @Override
    public double sumDouble(ToDoubleFunction<? super T> function) {
        return this.window().sumDouble(function);
    }

    @Override
    public Optional<T> avg() {
        return this.window().avg();
    }

    @Override
    public <U> Optional<U> avg(Function<? super T, ? extends U> function) {
        return this.window().avg(function);
    }

    @Override
    public double avgInt(ToIntFunction<? super T> function) {
        return this.window().avgInt(function);
    }

    @Override
    public double avgLong(ToLongFunction<? super T> function) {
        return this.window().avgLong(function);
    }

    @Override
    public double avgDouble(ToDoubleFunction<? super T> function) {
        return this.window().avgDouble(function);
    }

    @Override
    public Optional<T> min() {
        return this.window().min(Comparator.naturalOrder());
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.window().min(comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<U> min(Function<? super T, ? extends U> function) {
        return this.window().min(function);
    }

    @Override
    public <U> Optional<U> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().min(function, comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<T> minBy(Function<? super T, ? extends U> function) {
        return this.window().minBy(function);
    }

    @Override
    public <U> Optional<T> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().minBy(function, comparator);
    }

    @Override
    public Optional<T> max() {
        return this.window().max(Comparator.naturalOrder());
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.window().max(comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<U> max(Function<? super T, ? extends U> function) {
        return this.window().max(function);
    }

    @Override
    public <U> Optional<U> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().max(function, comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<T> maxBy(Function<? super T, ? extends U> function) {
        return this.window().maxBy(function);
    }

    @Override
    public <U> Optional<T> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().maxBy(function, comparator);
    }

    @Override
    public Optional<T> median() {
        return this.window().median(Comparator.naturalOrder());
    }

    @Override
    public Optional<T> median(Comparator<? super T> comparator) {
        return this.window().median(comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<T> medianBy(Function<? super T, ? extends U> function) {
        return this.window().medianBy(function);
    }

    @Override
    public <U> Optional<T> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().medianBy(function, comparator);
    }

    @Override
    public Optional<T> percentile(double percentile) {
        return this.window().percentile(percentile, Comparator.naturalOrder());
    }

    @Override
    public Optional<T> percentile(double percentile, Comparator<? super T> comparator) {
        return this.window().percentile(percentile, comparator);
    }

    @Override
    public <U extends Comparable<? super U>> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return this.window().percentileBy(percentile, function);
    }

    @Override
    public <U> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.window().percentileBy(percentile, function, comparator);
    }

    @Override
    public Optional<T> mode() {
        return this.window().mode();
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.window().allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.window().anyMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.window().noneMatch(predicate);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.window().collect(collector);
    }

    @Override
    public List<T> toList() {
        return this.window().toList();
    }

    @Override
    public <L extends List<T>> L toList(Supplier<L> factory) {
        return this.window().toList(factory);
    }

    @Override
    public Set<T> toSet() {
        return this.window().toSet();
    }

    @Override
    public <S extends Set<T>> S toSet(Supplier<S> factory) {
        return this.window().toSet(factory);
    }

    @Override
    public <C extends Collection<T>> C toCollection(Supplier<C> factory) {
        return this.window().toCollection(factory);
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.window().toMap(keyMapper, valueMapper);
    }

    public String toString() {
        return Seq.toString(this.window());
    }

    @Override
    public String toString(CharSequence delimiter) {
        return Seq.toString(this.window(), delimiter);
    }

    @Override
    public String toString(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.window().map(Objects::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }
}

