/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.graylog.events.processor.DBEventProcessorStateService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventDefinitionService
extends PaginatedDbService<EventDefinitionDto> {
    private static final Logger LOG = LoggerFactory.getLogger(DBEventDefinitionService.class);
    private static final String COLLECTION_NAME = "event_definitions";
    private final DBEventProcessorStateService stateService;

    @Inject
    public DBEventDefinitionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, DBEventProcessorStateService stateService) {
        super(mongoConnection, mapper, EventDefinitionDto.class, COLLECTION_NAME);
        this.stateService = stateService;
    }

    public PaginatedList<EventDefinitionDto> searchPaginated(SearchQuery query, Predicate<EventDefinitionDto> filter, String sortByField, int page, int perPage) {
        return this.findPaginatedWithQueryFilterAndSort(query.toDBQuery(), filter, this.getSortBuilder("asc", sortByField), page, perPage);
    }

    @Override
    public int delete(String id) {
        try {
            this.stateService.deleteByEventDefinitionId(id);
        }
        catch (Exception e) {
            LOG.error("Couldn't delete event processor state for <{}>", (Object)id, (Object)e);
        }
        return super.delete(id);
    }

    public List<EventDefinitionDto> getByNotificationId(String notificationId) {
        String field = String.format(Locale.US, "%s.%s", "notifications", "notification_id");
        return ImmutableList.copyOf((Iterator)this.db.find(DBQuery.is((String)field, (Object)notificationId)).iterator());
    }
}

