/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.statements;

import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;

public class VarAssignStatement
implements Statement {
    private final String name;
    private final Expression expr;

    public VarAssignStatement(String name, Expression expr) {
        this.name = name;
        this.expr = expr;
    }

    @Override
    public Void evaluate(EvaluationContext context) {
        Object result = this.expr.evaluate(context);
        context.define(this.name, this.expr.getType(), result);
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Expression getValueExpression() {
        return this.expr;
    }

    public String toString() {
        return "let " + this.name + " = " + this.expr.toString();
    }
}

