/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.ips;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class IpAddress {
    private InetAddress address;

    public IpAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress inetAddress() {
        return this.address;
    }

    public String toString() {
        return InetAddresses.toAddrString((InetAddress)this.address);
    }

    public IpAddress getAnonymized() {
        byte[] address = this.address.getAddress();
        address[address.length - 1] = 0;
        try {
            return new IpAddress(InetAddress.getByAddress(address));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpAddress)) {
            return false;
        }
        IpAddress ipAddress = (IpAddress)o;
        return Objects.equals(this.address, ipAddress.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

