/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Concat
extends AbstractFunction<String> {
    public static final String NAME = "concat";
    private final ParameterDescriptor<String, String> firstParam = ParameterDescriptor.string("first").description("First string").build();
    private final ParameterDescriptor<String, String> secondParam = ParameterDescriptor.string("second").description("Second string").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String first = Strings.nullToEmpty((String)this.firstParam.required(args, context));
        String second = Strings.nullToEmpty((String)this.secondParam.required(args, context));
        return first.concat(second);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.firstParam, this.secondParam)).description("Concatenates two strings").build();
    }
}

