/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Query;

class Search {
    private static final String FIELD_QUERIES = "queries";
    private final Document searchDocument;
    private final Set<Query> queries;

    Search(Document searchDocument) {
        this.searchDocument = searchDocument;
        Collection rawQueriesList = (Collection)searchDocument.get((Object)FIELD_QUERIES, Collection.class);
        this.queries = rawQueriesList == null ? Collections.emptySet() : new HashSet(rawQueriesList).stream().map(Query::new).collect(Collectors.toSet());
    }

    Set<Query> queries() {
        return this.queries;
    }

    Optional<Query> queryById(String queryId) {
        return this.queries.stream().filter(q -> queryId.equals(q.id())).findFirst();
    }

    Document searchDocument() {
        return this.searchDocument;
    }
}

