/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.sharing.IsViewSharedForUser;
import org.graylog.plugins.views.search.views.sharing.ViewSharing;
import org.graylog.plugins.views.search.views.sharing.ViewSharingService;
import org.graylog2.plugin.database.users.User;

class ViewPermissions {
    private final ViewService viewService;
    private final ViewSharingService viewSharingService;
    private final IsViewSharedForUser isViewSharedForUser;

    @Inject
    ViewPermissions(ViewService viewService, ViewSharingService viewSharingService, IsViewSharedForUser isViewSharedForUser) {
        this.viewService = viewService;
        this.viewSharingService = viewSharingService;
        this.isViewSharedForUser = isViewSharedForUser;
    }

    boolean isSearchPermitted(String id, User user, Predicate<ViewDTO> viewReadPermission) {
        Collection<ViewDTO> views = this.viewService.forSearch(id);
        Set<String> viewIds = ViewDTO.idsFrom(views);
        if (views.isEmpty()) {
            return false;
        }
        return this.hasSharedView(user, viewIds) || this.hasDirectReadPermissionForAny(views, viewReadPermission);
    }

    private boolean hasSharedView(User user, Set<String> viewIds) {
        return this.viewSharingService.forViews(viewIds).stream().anyMatch(vs -> this.isViewSharedForUser.isAllowedToSee(user, (ViewSharing)vs));
    }

    private boolean hasDirectReadPermissionForAny(Collection<ViewDTO> views, Predicate<ViewDTO> viewReadPermission) {
        return views.stream().anyMatch(viewReadPermission);
    }
}

