/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.export.AutoValue_ExportMessagesCommand;
import org.graylog.plugins.views.search.export.LinkedHashSetUtil;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;

@AutoValue
public abstract class ExportMessagesCommand {
    public static final ElasticsearchQueryString DEFAULT_QUERY = ElasticsearchQueryString.empty();
    public static final Set<String> DEFAULT_STREAMS = ImmutableSet.of();
    public static final LinkedHashSet<String> DEFAULT_FIELDS = LinkedHashSetUtil.linkedHashSetOf("timestamp", "source", "message");
    public static final int DEFAULT_CHUNK_SIZE = 1000;

    public static AbsoluteRange defaultTimeRange() {
        try {
            RelativeRange lastFiveMinutes = RelativeRange.create(300);
            return AbsoluteRange.create(lastFiveMinutes.getFrom(), lastFiveMinutes.getTo());
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException("Error creating default time range", e);
        }
    }

    public abstract AbsoluteRange timeRange();

    public abstract ElasticsearchQueryString queryString();

    public abstract Set<String> streams();

    public abstract LinkedHashSet<String> fieldsInOrder();

    public abstract List<Decorator> decorators();

    public abstract int chunkSize();

    public abstract OptionalInt limit();

    public static ExportMessagesCommand withDefaults() {
        return ExportMessagesCommand.builder().build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder timeRange(AbsoluteRange var1);

        public abstract Builder streams(Set<String> var1);

        public abstract Builder queryString(ElasticsearchQueryString var1);

        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public Builder fieldsInOrder(String ... fieldsInOrder) {
            return this.fieldsInOrder(LinkedHashSetUtil.linkedHashSetOf(fieldsInOrder));
        }

        public abstract Builder decorators(List<Decorator> var1);

        public abstract Builder chunkSize(int var1);

        public abstract Builder limit(Integer var1);

        abstract ExportMessagesCommand autoBuild();

        public ExportMessagesCommand build() {
            return this.autoBuild();
        }

        public static Builder create() {
            return new AutoValue_ExportMessagesCommand.Builder().timeRange(ExportMessagesCommand.defaultTimeRange()).streams(DEFAULT_STREAMS).queryString(DEFAULT_QUERY).fieldsInOrder(DEFAULT_FIELDS).decorators(Collections.emptyList()).chunkSize(1000);
        }
    }
}

