/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export.es;

import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import jersey.repackaged.com.google.common.collect.Lists;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.es.JestWrapper;
import org.graylog.plugins.views.search.export.es.RequestStrategy;

public class SearchAfter
implements RequestStrategy {
    private static final String TIEBREAKER_FIELD = "gl2_message_id";
    private final JestWrapper jestWrapper;
    private Object[] searchAfterValues = null;

    @Inject
    public SearchAfter(JestWrapper jestWrapper) {
        this.jestWrapper = jestWrapper;
    }

    @Override
    public List<SearchResult.Hit<Map, Void>> nextChunk(Search.Builder search, ExportMessagesCommand command) {
        SearchResult result = this.search(search);
        List hits = result.getHits(Map.class, false);
        this.searchAfterValues = this.lastHitSortFrom(hits);
        return hits;
    }

    private SearchResult search(Search.Builder search) {
        Search.Builder modified = search.addSort(this.timestampDescending());
        return (SearchResult)this.jestWrapper.execute(modified.build(), () -> "Failed to execute Search After request");
    }

    private ArrayList<Sort> timestampDescending() {
        return Lists.newArrayList((Object[])new Sort[]{new Sort("timestamp", Sort.Sorting.DESC), new Sort(TIEBREAKER_FIELD, Sort.Sorting.DESC)});
    }

    private Object[] lastHitSortFrom(List<SearchResult.Hit<Map, Void>> hits) {
        if (hits.isEmpty()) {
            return null;
        }
        SearchResult.Hit<Map, Void> lastHit = hits.get(hits.size() - 1);
        return lastHit.sort.toArray(new Object[0]);
    }

    @Override
    public SearchSourceBuilder configure(SearchSourceBuilder ssb) {
        return this.searchAfterValues == null ? ssb : ssb.searchAfter(this.searchAfterValues);
    }
}

