/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.rest.FieldTypesForStreamsRequest;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.exceptions.MissingStreamPermissionException;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Field Types")
@Path(value="/views/fields")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FieldTypesResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(FieldTypesResource.class);
    private final MappedFieldTypesService mappedFieldTypesService;
    private final PermittedStreams permittedStreams;

    @Inject
    public FieldTypesResource(MappedFieldTypesService mappedFieldTypesService, PermittedStreams permittedStreams) {
        this.mappedFieldTypesService = mappedFieldTypesService;
        this.permittedStreams = permittedStreams;
    }

    @GET
    @ApiOperation(value="Retrieve the list of all fields present in the system")
    public Set<MappedFieldTypeDTO> allFieldTypes() {
        return this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)this.permittedStreams.load(this::allowedToReadStream));
    }

    private boolean allowedToReadStream(String streamId) {
        return this.isPermitted("streams:read", streamId);
    }

    @POST
    @ApiOperation(value="Retrieve the field list of a given set of streams")
    @NoAuditEvent(value="This is not changing any data")
    public Set<MappedFieldTypeDTO> byStreams(FieldTypesForStreamsRequest request) {
        this.checkStreamPermission(request.streams());
        return this.mappedFieldTypesService.fieldTypesByStreamIds(request.streams());
    }

    private void checkStreamPermission(Set<String> streamIds) {
        Set notPermittedStreams = streamIds.stream().filter(s -> !this.isPermitted("streams:read", (String)s)).collect(Collectors.toSet());
        if (!notPermittedStreams.isEmpty()) {
            LOG.info("Not authorized to access resource id <{}>. User <{}> is missing permission <{}:{}>", new Object[]{streamIds, this.getSubject().getPrincipal(), "streams:read", streamIds});
            throw new MissingStreamPermissionException("Not authorized to access streams.", streamIds);
        }
    }
}

