/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.export.AuditContext;
import org.graylog.plugins.views.search.export.AuditingMessagesExporter;
import org.graylog.plugins.views.search.export.ChunkedRunner;
import org.graylog.plugins.views.search.export.CommandFactory;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesExporter;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog.plugins.views.search.export.ResultFormat;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.rest.ViewPermissionChecks;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Search/Messages", description="Simple search returning (matching) messages only, as CSV.")
@Path(value="/views/search/messages")
@RequiresAuthentication
public class MessagesResource
extends RestResource
implements PluginRestResource {
    private final CommandFactory commandFactory;
    private final SearchDomain searchDomain;
    private final SearchExecutionGuard executionGuard;
    private final PermittedStreams permittedStreams;
    private final ObjectMapper objectMapper;
    private final ViewPermissionChecks viewPermissionChecks;
    Function<Consumer<Consumer<SimpleMessageChunk>>, ChunkedOutput<SimpleMessageChunk>> asyncRunner = ChunkedRunner::runAsync;
    Function<AuditContext, MessagesExporter> messagesExporterFactory;

    @Inject
    public MessagesResource(MessagesExporter exporter, CommandFactory commandFactory, SearchDomain searchDomain, SearchExecutionGuard executionGuard, PermittedStreams permittedStreams, ObjectMapper objectMapper, ViewPermissionChecks viewPermissionChecks, EventBus eventBus) {
        this.commandFactory = commandFactory;
        this.searchDomain = searchDomain;
        this.executionGuard = executionGuard;
        this.permittedStreams = permittedStreams;
        this.objectMapper = objectMapper;
        this.viewPermissionChecks = viewPermissionChecks;
        this.messagesExporterFactory = context -> new AuditingMessagesExporter((AuditContext)context, eventBus, exporter);
    }

    @ApiOperation(value="Export messages as CSV", notes="Use this endpoint, if you want to configure export parameters freely instead of relying on an existing Search")
    @POST
    @Produces(value={"text/csv"})
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieve(@ApiParam @Valid MessagesRequest rawrequest) {
        MessagesRequest request = this.fillInIfNecessary(rawrequest);
        this.executionGuard.checkUserIsPermittedToSeeStreams(request.streams(), this::hasStreamReadPermission);
        ExportMessagesCommand command = this.commandFactory.buildFromRequest(request);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter().export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    private MessagesRequest fillInIfNecessary(MessagesRequest requestFromClient) {
        MessagesRequest request;
        MessagesRequest messagesRequest = request = requestFromClient != null ? requestFromClient : MessagesRequest.withDefaults();
        if (request.streams().isEmpty()) {
            request = request.toBuilder().streams((Set<String>)this.loadAllAllowedStreamsForUser()).build();
        }
        return request;
    }

    @ApiOperation(value="Export a search result as CSV")
    @POST
    @Path(value="{searchId}")
    @Produces(value={"text/csv"})
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieveForSearch(@ApiParam(value="ID of an existing Search", name="searchId") @PathParam(value="searchId") String searchId, @ApiParam(value="Optional overrides") @Valid ResultFormat formatFromClient) {
        ResultFormat format = this.emptyIfNull(formatFromClient);
        Search search = this.loadSearch(searchId, format.executionState());
        ExportMessagesCommand command = this.commandFactory.buildWithSearchOnly(search, format);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter(searchId).export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    @ApiOperation(value="Export a message table as CSV")
    @POST
    @Path(value="{searchId}/{searchTypeId}")
    @Produces(value={"text/csv"})
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieveForSearchType(@ApiParam(value="ID of an existing Search", name="searchId") @PathParam(value="searchId") String searchId, @ApiParam(value="ID of a Message Table contained in the Search", name="searchTypeId") @PathParam(value="searchTypeId") String searchTypeId, @ApiParam(value="Optional overrides") @Valid ResultFormat formatFromClient) {
        ResultFormat format = this.emptyIfNull(formatFromClient);
        Search search = this.loadSearch(searchId, format.executionState());
        ExportMessagesCommand command = this.commandFactory.buildWithMessageList(search, searchTypeId, format);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter(searchId, searchTypeId).export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    private MessagesExporter exporter() {
        return this.exporter(null, null);
    }

    private MessagesExporter exporter(String searchId) {
        return this.exporter(searchId, null);
    }

    private MessagesExporter exporter(String searchId, String searchTypeId) {
        return this.messagesExporterFactory.apply(new AuditContext(this.userName(), searchId, searchTypeId));
    }

    private String userName() {
        return Objects.requireNonNull(this.getCurrentUser()).getName();
    }

    private ResultFormat emptyIfNull(ResultFormat format) {
        return format == null ? ResultFormat.empty() : format;
    }

    private Search loadSearch(String searchId, Map<String, Object> executionState) {
        Search search = this.searchDomain.getForUser(searchId, this.getCurrentUser(), this::hasViewReadPermission).orElseThrow(() -> new NotFoundException("Search with id " + searchId + " does not exist"));
        search = search.addStreamsToQueriesWithoutStreams(this::loadAllAllowedStreamsForUser);
        search = search.applyExecutionState(this.objectMapper, executionState);
        this.executionGuard.check(search, this::hasStreamReadPermission);
        return search;
    }

    private boolean hasViewReadPermission(ViewDTO view) {
        return this.viewPermissionChecks.allowedToSeeView(this.getCurrentUser(), view, this::isPermitted);
    }

    private ImmutableSet<String> loadAllAllowedStreamsForUser() {
        return this.permittedStreams.load(this::hasStreamReadPermission);
    }

    private boolean hasStreamReadPermission(String streamId) {
        return this.isPermitted("streams:read", streamId);
    }
}

