/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.rest.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.clock.JobSchedulerSystemClock;
import org.graylog.scheduler.rest.requests.AutoValue_CreateJobTriggerRequest;
import org.joda.time.DateTime;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CreateJobTriggerRequest {
    private static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    private static final String FIELD_START_TIME = "start_time";
    private static final String FIELD_END_TIME = "end_time";
    private static final String FIELD_NEXT_TIME = "next_time";
    private static final String FIELD_SCHEDULE = "schedule";
    private static final String FIELD_DATA = "data";

    @JsonProperty(value="job_definition_id")
    public abstract String jobDefinitionId();

    @JsonProperty(value="start_time")
    public abstract DateTime startTime();

    @JsonProperty(value="end_time")
    public abstract Optional<DateTime> endTime();

    @JsonProperty(value="next_time")
    public abstract DateTime nextTime();

    @JsonProperty(value="schedule")
    public abstract JobSchedule schedule();

    @JsonProperty(value="data")
    public abstract Optional<JobTriggerData> data();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public JobTriggerDto toDto() {
        return this.toDto(new JobSchedulerSystemClock());
    }

    public JobTriggerDto toDto(JobSchedulerClock clock) {
        return JobTriggerDto.builderWithClock(clock).jobDefinitionId(this.jobDefinitionId()).startTime(this.startTime()).endTime(this.endTime().orElse(null)).nextTime(this.nextTime()).status(JobTriggerStatus.RUNNABLE).schedule(this.schedule()).data(this.data().orElse(null)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return Builder.create(new JobSchedulerSystemClock());
        }

        public static Builder create(JobSchedulerClock clock) {
            DateTime now = clock.nowUTC();
            return new AutoValue_CreateJobTriggerRequest.Builder().startTime(now).nextTime(now);
        }

        @JsonProperty(value="job_definition_id")
        public abstract Builder jobDefinitionId(String var1);

        @JsonProperty(value="start_time")
        public abstract Builder startTime(DateTime var1);

        @JsonProperty(value="end_time")
        public abstract Builder endTime(@Nullable DateTime var1);

        @JsonProperty(value="next_time")
        public abstract Builder nextTime(DateTime var1);

        @JsonProperty(value="schedule")
        public abstract Builder schedule(JobSchedule var1);

        @JsonProperty(value="data")
        public abstract Builder data(@Nullable JobTriggerData var1);

        public abstract CreateJobTriggerRequest build();
    }
}

