/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap;

import com.github.rvesse.airline.annotations.Option;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.bootstrap.CmdLineTool;
import org.graylog2.bootstrap.Main;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.GenericBindings;
import org.graylog2.shared.bindings.GenericInitializerBindings;
import org.graylog2.shared.bindings.SchedulerBindings;
import org.graylog2.shared.bindings.ServerStatusBindings;
import org.graylog2.shared.bindings.SharedPeriodicalBindings;
import org.graylog2.shared.bindings.ValidatorModule;
import org.graylog2.shared.initializers.ServiceManagerListener;
import org.graylog2.shared.security.SecurityBindings;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.system.stats.SystemStatsModule;
import org.jsoftbiz.utils.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerBootstrap
extends CmdLineTool {
    private static final Logger LOG = LoggerFactory.getLogger(ServerBootstrap.class);
    @Option(name={"-p", "--pidfile"}, description="File containing the PID of Graylog")
    private String pidFile = TMPDIR + FILE_SEPARATOR + "graylog.pid";
    @Option(name={"-np", "--no-pid-file"}, description="Do not write a PID file (overrides -p/--pidfile)")
    private boolean noPidFile = false;

    public ServerBootstrap(String commandName, BaseConfiguration configuration) {
        super(commandName, configuration);
        this.commandName = commandName;
    }

    protected abstract void startNodeRegistration(Injector var1);

    public String getPidFile() {
        return this.pidFile;
    }

    public boolean isNoPidFile() {
        return this.noPidFile;
    }

    @Override
    protected void beforeStart() {
        super.beforeStart();
        if (!this.isNoPidFile()) {
            this.savePidFile(this.getPidFile());
        }
        this.setNettyNativeDefaults();
    }

    private void setNettyNativeDefaults() {
        if (System.getProperty("io.netty.native.workdir") == null) {
            System.setProperty("io.netty.native.workdir", this.configuration.getNativeLibDir().toAbsolutePath().toString());
        }
        if (System.getProperty("io.netty.native.deleteLibAfterLoading") == null) {
            System.setProperty("io.netty.native.deleteLibAfterLoading", "false");
        }
    }

    @Override
    protected void startCommand() {
        ServiceManager serviceManager;
        ActivityWriter activityWriter;
        AuditEventSender auditEventSender = (AuditEventSender)this.injector.getInstance(AuditEventSender.class);
        NodeId nodeId = (NodeId)this.injector.getInstance(NodeId.class);
        String systemInformation = Tools.getSystemInformation();
        ImmutableMap auditEventContext = ImmutableMap.of((Object)"version", (Object)version.toString(), (Object)"java", (Object)systemInformation, (Object)"node_id", (Object)nodeId.toString());
        auditEventSender.success(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
        OS os = OS.getOs();
        LOG.info("Graylog {} {} starting up", (Object)this.commandName, (Object)version);
        LOG.info("JRE: {}", (Object)systemInformation);
        LOG.info("Deployment: {}", (Object)this.configuration.getInstallationSource());
        LOG.info("OS: {}", (Object)os.getPlatformName());
        LOG.info("Arch: {}", (Object)os.getArch());
        ServerStatus serverStatus = (ServerStatus)this.injector.getInstance(ServerStatus.class);
        serverStatus.initialize();
        this.startNodeRegistration(this.injector);
        try {
            activityWriter = (ActivityWriter)this.injector.getInstance(ActivityWriter.class);
            serviceManager = (ServiceManager)this.injector.getInstance(ServiceManager.class);
        }
        catch (ProvisionException e) {
            LOG.error("Guice error", (Throwable)e);
            this.annotateProvisionException(e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
            return;
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this.injector.getInstance(this.shutdownHook())));
        MessageInput.setDefaultRecvBufferSize(this.configuration.getUdpRecvBufferSizes());
        ServiceManagerListener serviceManagerListener = (ServiceManagerListener)((Object)this.injector.getInstance(ServiceManagerListener.class));
        serviceManager.addListener((ServiceManager.Listener)serviceManagerListener);
        try {
            serviceManager.startAsync().awaitHealthy();
        }
        catch (Exception e) {
            try {
                serviceManager.stopAsync().awaitStopped((long)this.configuration.getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                LOG.error("Unable to shutdown properly on time. {}", (Object)serviceManager.servicesByState());
            }
            LOG.error("Graylog startup failed. Exiting. Exception was:", (Throwable)e);
            auditEventSender.failure(AuditActor.system(nodeId), "server:node_startup:initiate", (Map<String, Object>)auditEventContext);
            System.exit(-1);
        }
        LOG.info("Services started, startup times in ms: {}", (Object)serviceManager.startupTimes());
        activityWriter.write(new Activity("Started up.", Main.class));
        LOG.info("Graylog " + this.commandName + " up and running.");
        auditEventSender.success(AuditActor.system(nodeId), "server:node_startup:complete", (Map<String, Object>)auditEventContext);
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected void savePidFile(String pidFile) {
        String pid = Tools.getPID();
        Path pidFilePath = Paths.get(pidFile, new String[0]);
        pidFilePath.toFile().deleteOnExit();
        try {
            if (Strings.isNullOrEmpty((String)pid) || "unknown".equals(pid)) {
                throw new Exception("Could not determine PID.");
            }
            Files.write(pidFilePath, pid.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            LOG.error("Could not write PID file: " + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    protected List<Module> getSharedBindingsModules() {
        List<Module> result = super.getSharedBindingsModules();
        result.add((Module)new GenericBindings());
        result.add((Module)new SecurityBindings());
        result.add((Module)new ServerStatusBindings(this.capabilities()));
        result.add((Module)new ValidatorModule());
        result.add((Module)new SharedPeriodicalBindings());
        result.add((Module)new SchedulerBindings());
        result.add((Module)new GenericInitializerBindings());
        result.add((Module)new SystemStatsModule(this.configuration.isDisableSigar()));
        return result;
    }

    protected void annotateProvisionException(ProvisionException e) {
        this.annotateInjectorExceptions(e.getErrorMessages());
        throw e;
    }

    protected abstract Class<? extends Runnable> shutdownHook();
}

