/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog.plugins.views.search.timeranges.OffsetRange;
import org.graylog2.contentpacks.model.entities.AutoValue_PivotEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="pivot")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class PivotEntity
implements SearchTypeEntity {
    public static final String NAME = "pivot";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @JsonProperty
    public abstract Optional<String> name();

    @JsonProperty(value="row_groups")
    public abstract List<BucketSpec> rowGroups();

    @JsonProperty(value="column_groups")
    public abstract List<BucketSpec> columnGroups();

    @JsonProperty
    public abstract List<SeriesSpec> series();

    @JsonProperty
    public abstract List<SortSpec> sort();

    @JsonProperty
    public abstract boolean rollup();

    @Override
    @Nullable
    public abstract Filter filter();

    public abstract Builder toBuilder();

    @Override
    public Builder toGenericBuilder() {
        return this.toBuilder();
    }

    public static Builder builder() {
        return new AutoValue_PivotEntity.Builder().type(NAME).rowGroups((List<BucketSpec>)ImmutableList.of()).columnGroups((List<BucketSpec>)ImmutableList.of()).sort((List<SortSpec>)ImmutableList.of()).streams(Collections.emptySet());
    }

    @Override
    public SearchType toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        return Pivot.builder().streams(this.mappedStreams(nativeEntities)).name(this.name().orElse(null)).sort(this.sort()).timerange((DerivedTimeRange)this.timerange().orElse(null)).rowGroups(this.rowGroups()).columnGroups(this.columnGroups()).series(this.series()).rollup(this.rollup()).query(this.query().orElse(null)).filter(this.filter()).type(this.type()).id(this.id()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements SearchTypeEntity.Builder {
        @JsonCreator
        public static Builder createDefault() {
            return PivotEntity.builder().sort(Collections.emptyList()).streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty(value="row_groups")
        public abstract Builder rowGroups(@Nullable List<BucketSpec> var1);

        @JsonProperty(value="column_groups")
        public abstract Builder columnGroups(@Nullable List<BucketSpec> var1);

        @JsonProperty
        public abstract Builder series(List<SeriesSpec> var1);

        @JsonProperty
        public abstract Builder sort(List<SortSpec> var1);

        @JsonProperty
        public abstract Builder rollup(boolean var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
        @JsonSubTypes(value={@JsonSubTypes.Type(name="absolute", value=AbsoluteRange.class), @JsonSubTypes.Type(name="relative", value=RelativeRange.class), @JsonSubTypes.Type(name="keyword", value=KeywordRange.class), @JsonSubTypes.Type(name="offset", value=OffsetRange.class)})
        public Builder timerange(@Nullable TimeRange timerange) {
            return this.timerange(timerange == null ? null : DerivedTimeRange.of(timerange));
        }

        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @Override
        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @Override
        public abstract PivotEntity build();
    }
}

