/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.graylog2.contentpacks.model.entities.AutoValue_RelativeRangeEntity;
import org.graylog2.contentpacks.model.entities.ModelTypeEntity;
import org.graylog2.contentpacks.model.entities.TimeRangeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_RelativeRangeEntity.Builder.class)
@AutoValue
public abstract class RelativeRangeEntity
extends TimeRangeEntity {
    static final String TYPE = "relative";
    private static final String FIELD_RANGE = "range";

    @JsonProperty(value="range")
    public abstract ValueReference range();

    public static RelativeRangeEntity of(RelativeRange relativeRange) {
        int range = relativeRange.getRange();
        return RelativeRangeEntity.builder().range(ValueReference.of(range)).build();
    }

    @Override
    public final TimeRange convert(Map<String, ValueReference> parameters) {
        int range = this.range().asInteger(parameters);
        try {
            return RelativeRange.create(range);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException("Invalid timerange.", e);
        }
    }

    static Builder builder() {
        return new AutoValue_RelativeRangeEntity.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder
    implements TimeRangeEntity.TimeRangeBuilder<Builder> {
        Builder() {
        }

        @JsonProperty(value="range")
        abstract Builder range(ValueReference var1);

        abstract RelativeRangeEntity autoBuild();

        RelativeRangeEntity build() {
            this.type(ModelTypeEntity.of(RelativeRangeEntity.TYPE));
            return this.autoBuild();
        }
    }
}

