/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.google.common.base.MoreObjects;
import com.mongodb.BasicDBObject;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.timeranges.TimeRangeFactory;

public class DashboardWidgetCreator {
    private final WidgetCacheTime.Factory cacheTimeFactory;
    private final TimeRangeFactory timeRangeFactory;

    @Inject
    public DashboardWidgetCreator(WidgetCacheTime.Factory cacheTimeFactory, TimeRangeFactory timeRangeFactory) {
        this.cacheTimeFactory = cacheTimeFactory;
        this.timeRangeFactory = timeRangeFactory;
    }

    public DashboardWidget fromPersisted(BasicDBObject fields) throws InvalidRangeParametersException {
        String type = (String)fields.get("type");
        BasicDBObject config = (BasicDBObject)fields.get("config");
        String widgetId = (String)fields.get("id");
        BasicDBObject timerangeConfig = (BasicDBObject)config.get("timerange");
        TimeRange timeRange = this.timeRangeFactory.create((Map<String, Object>)timerangeConfig);
        String description = (String)fields.get("description");
        int cacheTime = (Integer)MoreObjects.firstNonNull((Object)fields.get("cache_time"), (Object)0);
        return this.buildDashboardWidget(type, widgetId, description, cacheTime, (Map<String, Object>)config, timeRange, (String)fields.get("creator_user_id"));
    }

    public DashboardWidget buildDashboardWidget(String type, String widgetId, String description, int requestedCacheTime, Map<String, Object> config, TimeRange timeRange, String creatorUserId) {
        WidgetCacheTime cacheTime = this.cacheTimeFactory.create(requestedCacheTime);
        return new DashboardWidget(type, widgetId, timeRange, description, cacheTime, config, creatorUserId);
    }
}

