/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mongodb.DBCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.exception.GrokException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.grok.GrokPatternsUpdatedEvent;
import org.graylog2.plugin.database.ValidationException;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbGrokPatternService
implements GrokPatternService {
    public static final String COLLECTION_NAME = "grok_patterns";
    public static final String INDEX_NAME = "idx_name_asc_unique";
    private static final Logger log = LoggerFactory.getLogger(MongoDbGrokPatternService.class);
    private final JacksonDBCollection<GrokPattern, ObjectId> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    protected MongoDbGrokPatternService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), GrokPattern.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.clusterBus = clusterBus;
    }

    private static void createIndex(MongoConnection mongoConnection) {
        IndexOptions indexOptions = new IndexOptions().name(INDEX_NAME).unique(true);
        mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME).createIndex(Indexes.ascending((String[])new String[]{"name"}), indexOptions);
    }

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.dbCollection.findOneById((Object)new ObjectId(patternId));
        if (pattern == null) {
            throw new NotFoundException("Couldn't find Grok pattern with ID " + patternId);
        }
        return pattern;
    }

    @Override
    public Optional<GrokPattern> loadByName(String name) {
        GrokPattern pattern = (GrokPattern)this.dbCollection.findOne(DBQuery.is((String)"name", (Object)name));
        return Optional.ofNullable(pattern);
    }

    @Override
    public Set<GrokPattern> bulkLoad(Collection<String> patternIds) {
        DBCursor dbCursor = this.dbCollection.find(DBQuery.in((String)"_id", patternIds));
        return ImmutableSet.copyOf((Iterator)dbCursor);
    }

    @Override
    public Set<GrokPattern> loadAll() {
        try (DBCursor grokPatterns = this.dbCollection.find();){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)grokPatterns);
            return immutableSet;
        }
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Invalid pattern " + pattern);
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + pattern + "\n" + e.getMessage());
        }
        if (this.loadByName(pattern.name()).isPresent()) {
            throw new ValidationException("Grok pattern " + pattern.name() + " already exists");
        }
        WriteResult result = this.dbCollection.save((Object)pattern);
        GrokPattern savedGrokPattern = (GrokPattern)result.getSavedObject();
        this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)savedGrokPattern.name())));
        return savedGrokPattern;
    }

    @Override
    public GrokPattern update(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Invalid pattern " + pattern);
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + pattern + "\n" + e.getMessage());
        }
        if (pattern.id() == null) {
            throw new ValidationException("Invalid pattern " + pattern);
        }
        WriteResult result = this.dbCollection.update(DBQuery.is((String)"_id", (Object)new ObjectId(pattern.id())), (Object)pattern);
        if (result.isUpdateOfExisting()) {
            this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)pattern.name())));
            return pattern;
        }
        throw new ValidationException("Invalid pattern " + pattern);
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, boolean replace) throws ValidationException {
        if (!replace) {
            for (GrokPattern pattern : this.loadAll()) {
                boolean patternExists = patterns.stream().anyMatch(p -> p.name().equals(pattern.name()));
                if (!patternExists) continue;
                throw new ValidationException("Grok pattern " + pattern.name() + " already exists");
            }
        }
        try {
            if (!this.validateAll(patterns)) {
                throw new ValidationException("Invalid patterns");
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid patterns.\n" + e.getMessage());
        }
        if (replace) {
            this.deleteAll();
        }
        ImmutableList.Builder savedPatterns = ImmutableList.builder();
        ImmutableSet.Builder patternNames = ImmutableSet.builder();
        for (GrokPattern pattern : patterns) {
            WriteResult result = this.dbCollection.save((Object)pattern);
            GrokPattern savedGrokPattern = (GrokPattern)result.getSavedObject();
            savedPatterns.add((Object)savedGrokPattern);
            patternNames.add((Object)savedGrokPattern.name());
        }
        this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)patternNames.build()));
        return savedPatterns.build();
    }

    @Override
    public Map<String, Object> match(GrokPattern pattern, String sampleData) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        Grok grok = grokCompiler.compile("%{" + pattern.name() + "}");
        return grok.match((CharSequence)sampleData).captureFlattened();
    }

    @Override
    public boolean validate(GrokPattern pattern) throws GrokException {
        Preconditions.checkNotNull((Object)pattern, (Object)"A pattern must be given");
        Set<GrokPattern> patterns = this.loadAll();
        boolean fieldsMissing = Strings.isNullOrEmpty((String)pattern.name()) || Strings.isNullOrEmpty((String)pattern.pattern());
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        grokCompiler.compile("%{" + pattern.name() + "}");
        return !fieldsMissing;
    }

    @Override
    public boolean validateAll(Collection<GrokPattern> newPatterns) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern newPattern : newPatterns) {
            boolean fieldsMissing;
            boolean bl = fieldsMissing = Strings.isNullOrEmpty((String)newPattern.name()) || Strings.isNullOrEmpty((String)newPattern.pattern());
            if (fieldsMissing) {
                return false;
            }
            grokCompiler.register(newPattern.name(), newPattern.pattern());
        }
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        for (GrokPattern newPattern : newPatterns) {
            grokCompiler.compile("%{" + newPattern.name() + "}");
        }
        return true;
    }

    @Override
    public int delete(String patternId) {
        GrokPattern grokPattern;
        try {
            grokPattern = this.load(patternId);
        }
        catch (NotFoundException e) {
            log.debug("Couldn't find grok pattern with ID <{}> for deletion", (Object)patternId, (Object)e);
            return 0;
        }
        ObjectId id = new ObjectId(patternId);
        String name = grokPattern.name();
        int deletedPatterns = this.dbCollection.removeById((Object)id).getN();
        this.clusterBus.post(GrokPatternsDeletedEvent.create((Set<String>)ImmutableSet.of((Object)name)));
        return deletedPatterns;
    }

    @Override
    public int deleteAll() {
        Set<GrokPattern> grokPatterns = this.loadAll();
        Set<String> patternNames = grokPatterns.stream().map(GrokPattern::name).collect(Collectors.toSet());
        int deletedPatterns = this.dbCollection.remove(DBQuery.empty()).getN();
        this.clusterBus.post(GrokPatternsDeletedEvent.create(patternNames));
        return deletedPatterns;
    }
}

