/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import io.searchbox.client.JestClient;
import io.searchbox.indices.mapping.GetMapping;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFieldTypePoller {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFieldTypePoller.class);
    private final JestClient jestClient;
    private final Indices indices;
    private final Timer pollTimer;

    @Inject
    public IndexFieldTypePoller(JestClient jestClient, Indices indices, MetricRegistry metricRegistry) {
        this.jestClient = jestClient;
        this.indices = indices;
        this.pollTimer = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"indexPollTime"}));
    }

    public Set<IndexFieldTypesDTO> poll(IndexSet indexSet, Set<IndexFieldTypesDTO> existingIndexTypes) {
        String activeWriteIndex = indexSet.getActiveWriteIndex();
        Set existingIndexNames = existingIndexTypes.stream().map(IndexFieldTypesDTO::indexName).collect(Collectors.toSet());
        return this.indices.getIndices(indexSet, "open").stream().filter(indexName -> indexName.equals(activeWriteIndex) || !existingIndexNames.contains(indexName)).map(indexName -> this.pollIndex((String)indexName, indexSet.getConfig().id())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public Optional<IndexFieldTypesDTO> pollIndex(String indexName, String indexSetId) {
        Object result;
        GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).build();
        try (Timer.Context ignored = this.pollTimer.time();){
            result = JestUtils.execute(this.jestClient, getMapping, () -> "Unable to get index mapping for index: " + indexName);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Couldn't get mapping for index <{}>", (Object)indexName, (Object)e);
            } else {
                LOG.error("Couldn't get mapping for index <{}>: {}", (Object)indexName, (Object)ExceptionUtils.getRootCauseMessage(e));
            }
            return Optional.empty();
        }
        JsonNode properties = result.getJsonObject().path(indexName).path("mappings").path("message").path("properties");
        if (properties.isMissingNode()) {
            LOG.error("Invalid mapping response: {}", (Object)result.getJsonString());
            return Optional.empty();
        }
        Spliterator fieldSpliterator = Spliterators.spliteratorUnknownSize(properties.fields(), 1024);
        Set<FieldTypeDTO> fieldsMap = StreamSupport.stream(fieldSpliterator, false).map(field -> Maps.immutableEntry((Object)((String)field.getKey()), (Object)((JsonNode)field.getValue()).path("type").asText())).filter(field -> !((String)field.getValue()).isEmpty()).map(field -> FieldTypeDTO.create((String)field.getKey(), (String)field.getValue())).collect(Collectors.toSet());
        return Optional.of(IndexFieldTypesDTO.create(indexSetId, indexName, fieldsMap));
    }
}

