/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.events.inputs.IOStateChangedEvent;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStateListener.class);
    private NotificationService notificationService;
    private ActivityWriter activityWriter;
    private ServerStatus serverStatus;

    @Inject
    public InputStateListener(EventBus eventBus, NotificationService notificationService, ActivityWriter activityWriter, ServerStatus serverStatus) {
        this.notificationService = notificationService;
        this.activityWriter = activityWriter;
        this.serverStatus = serverStatus;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputStateChanged(IOStateChangedEvent<MessageInput> event) {
        IOState<MessageInput> state = event.changedState();
        MessageInput input = state.getStoppable();
        switch (event.newState()) {
            case FAILED: {
                this.activityWriter.write(new Activity(state.getDetailedMessage(), InputRegistry.class));
                Notification notification = this.notificationService.buildNow();
                notification.addType(Notification.Type.INPUT_FAILED_TO_START).addSeverity(Notification.Severity.NORMAL);
                notification.addNode(this.serverStatus.getNodeId().toString());
                notification.addDetail("input_id", input.getId());
                notification.addDetail("reason", state.getDetailedMessage());
                this.notificationService.publishIfFirst(notification);
                break;
            }
            case RUNNING: {
                this.notificationService.fixed(Notification.Type.NO_INPUT_RUNNING);
            }
            default: {
                String msg = "Input [" + input.getName() + "/" + input.getId() + "] is now " + event.newState().toString();
                this.activityWriter.write(new Activity(msg, InputStateListener.class));
            }
        }
        LOG.debug("Input State of [{}/{}] changed: {} -> {}", new Object[]{input.getTitle(), input.getId(), event.oldState(), event.newState()});
        LOG.info("Input [{}/{}] is now {}", new Object[]{input.getName(), input.getId(), event.newState()});
    }
}

