/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.List;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.alerts.AlertScanner;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertScannerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(AlertScannerThread.class);
    private final StreamService streamService;
    private final Configuration configuration;
    private final AlertScanner alertScanner;

    @Inject
    public AlertScannerThread(StreamService streamService, Configuration configuration, AlertScanner alertScanner) {
        this.streamService = streamService;
        this.configuration = configuration;
        this.alertScanner = alertScanner;
    }

    @Override
    public void doRun() {
        LOG.debug("Running alert checks.");
        List<Stream> alertedStreams = this.streamService.loadAllWithConfiguredAlertConditions();
        LOG.debug("There are {}\u00a0streams with configured alert conditions.", (Object)alertedStreams.size());
        for (Stream stream : alertedStreams) {
            LOG.debug("Stream [{}] has [{}] configured alert conditions.", (Object)stream, (Object)this.streamService.getAlertConditions(stream).size());
            if (stream.isPaused().booleanValue()) {
                LOG.debug("Stream [{}] has been paused. Skipping alert check.", (Object)stream);
                continue;
            }
            this.streamService.getAlertConditions(stream).forEach(alertCondition -> this.alertScanner.checkAlertCondition(stream, (AlertCondition)alertCondition));
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.configuration.isEnableLegacyAlerts();
    }

    @Override
    public int getInitialDelaySeconds() {
        return 10;
    }

    @Override
    public int getPeriodSeconds() {
        return this.configuration.getAlertCheckInterval();
    }
}

