/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alarmcallbacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.mail.EmailException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.types.DummyAlertCondition;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackListSummary;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackSummary;
import org.graylog2.rest.models.alarmcallbacks.responses.AvailableAlarmCallbackSummaryResponse;
import org.graylog2.rest.models.alarmcallbacks.responses.AvailableAlarmCallbacksResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;

@RequiresAuthentication
@Api(value="AlarmCallbacks", description="Manage legacy alarm callbacks (aka alert notifications)")
@Path(value="/alerts/callbacks")
@Produces(value={"application/json"})
public class AlarmCallbacksResource
extends RestResource {
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final StreamService streamService;
    private final Set<AlarmCallback> availableAlarmCallbacks;
    private final AlarmCallbackFactory alarmCallbackFactory;

    @Inject
    public AlarmCallbacksResource(AlarmCallbackConfigurationService alarmCallbackConfigurationService, StreamService streamService, Set<AlarmCallback> availableAlarmCallbacks, AlarmCallbackFactory alarmCallbackFactory) {
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.streamService = streamService;
        this.availableAlarmCallbacks = availableAlarmCallbacks;
        this.alarmCallbackFactory = alarmCallbackFactory;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks")
    public AlarmCallbackListSummary all() throws NotFoundException {
        List<AlarmCallbackSummary> alarmCallbacks = this.streamService.loadAll().stream().filter(stream -> this.isPermitted("streams:read", stream.getId())).flatMap(stream -> this.alarmCallbackConfigurationService.getForStream((Stream)stream).stream().map(callback -> AlarmCallbackSummary.create(callback.getId(), callback.getStreamId(), callback.getType(), callback.getTitle(), callback.getConfiguration(), callback.getCreatedAt(), callback.getCreatorUserId()))).collect(Collectors.toList());
        return AlarmCallbackListSummary.create(alarmCallbacks);
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks types")
    public AvailableAlarmCallbacksResponse available() {
        HashMap types = Maps.newHashMapWithExpectedSize((int)this.availableAlarmCallbacks.size());
        for (AlarmCallback availableAlarmCallback : this.availableAlarmCallbacks) {
            AvailableAlarmCallbackSummaryResponse type = new AvailableAlarmCallbackSummaryResponse();
            type.name = availableAlarmCallback.getName();
            type.requested_configuration = this.getConfigurationRequest(availableAlarmCallback).asList();
            types.put(availableAlarmCallback.getClass().getCanonicalName(), type);
        }
        AvailableAlarmCallbacksResponse response = new AvailableAlarmCallbacksResponse();
        response.types = types;
        return response;
    }

    @POST
    @Timed
    @Path(value="/{alarmCallbackId}/test")
    @ApiOperation(value="Send a test alert for a given alarm callback")
    @ApiResponses(value={@ApiResponse(code=404, message="Alarm callback not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=500, message="Error while testing alarm callback")})
    @NoAuditEvent(value="only used to test alert notifications")
    public Response test(@ApiParam(name="alarmCallbackId", value="The alarm callback id to send a test alert for.", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws TransportConfigurationException, EmailException, NotFoundException {
        AlarmCallbackConfiguration alarmCallbackConfiguration = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        String streamId = alarmCallbackConfiguration.getStreamId();
        this.checkPermission("streams:edit", streamId);
        Stream stream = this.streamService.load(streamId);
        DummyAlertCondition testAlertCondition = new DummyAlertCondition(stream, null, Tools.nowUTC(), this.getSubject().getPrincipal().toString(), Collections.emptyMap(), "Test Alert");
        try {
            AbstractAlertCondition.CheckResult checkResult = testAlertCondition.runCheck();
            AlarmCallback alarmCallback = this.alarmCallbackFactory.create(alarmCallbackConfiguration);
            alarmCallback.call(stream, checkResult);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.ok().build();
    }

    private ConfigurationRequest getConfigurationRequest(AlarmCallback callback) {
        if (callback instanceof EmailAlarmCallback && this.isPermitted("users:list")) {
            return ((EmailAlarmCallback)callback).getEnrichedRequestedConfiguration();
        }
        return callback.getRequestedConfiguration();
    }
}

