/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.dashboards;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetResultCache;
import org.graylog2.database.NotFoundException;
import org.graylog2.rest.models.dashboards.responses.WidgetSummary;
import org.graylog2.rest.resources.dashboards.LegacyDashboardsResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Legacy/Dashboards/Widgets", description="Manage widgets of an existing dashboard")
@Path(value="/legacy/dashboards/{dashboardId}/widgets")
public class LegacyDashboardWidgetsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyDashboardWidgetsResource.class);
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final ActivityWriter activityWriter;
    private final WidgetResultCache widgetResultCache;
    private final DashboardService dashboardService;

    @Inject
    public LegacyDashboardWidgetsResource(DashboardWidgetCreator dashboardWidgetCreator, ActivityWriter activityWriter, WidgetResultCache widgetResultCache, DashboardService dashboardService) {
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.activityWriter = activityWriter;
        this.widgetResultCache = widgetResultCache;
        this.dashboardService = dashboardService;
    }

    @GET
    @Deprecated
    @Timed
    @ApiOperation(value="Get a widget")
    @Path(value="/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    public WidgetSummary getWidget(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException {
        this.checkPermission("dashboards:read", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        return WidgetSummary.create(widget.getId(), widget.getDescription(), widget.getType(), widget.getCacheTime(), widget.getCreatorUserId(), widget.getConfig());
    }

    @DELETE
    @Deprecated
    @Timed
    @ApiOperation(value="Delete a widget")
    @Path(value="/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found.")})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:dashboard_widget:delete")
    public void remove(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        this.dashboardService.removeWidget(dashboard, widget);
        String msg = "Deleted widget <" + widgetId + "> from dashboard <" + dashboardId + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, LegacyDashboardsResource.class));
    }

    @GET
    @Deprecated
    @Timed
    @ApiOperation(value="Get a single widget value.")
    @Path(value="/{widgetId}/value")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=504, message="Computation failed on indexer side.")})
    @Produces(value={"application/json"})
    public Map<String, Object> widgetValue(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) throws NotFoundException, InvalidWidgetConfigurationException {
        this.checkPermission("dashboards:read", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            String msg = "Widget " + widgetId + " on dashboard " + dashboardId + " not found.";
            LOG.error(msg);
            throw new javax.ws.rs.NotFoundException(msg);
        }
        return this.widgetResultCache.getComputationResultForDashboardWidget(widget).asMap();
    }
}

