/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.dashboards;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.models.dashboards.responses.DashboardList;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Legacy/Dashboards", description="Manage dashboards")
@Path(value="/legacy/dashboards")
public class LegacyDashboardsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyDashboardsResource.class);
    private final DashboardService dashboardService;
    private final ActivityWriter activityWriter;

    @Inject
    public LegacyDashboardsResource(DashboardService dashboardService, ActivityWriter activityWriter) {
        this.dashboardService = dashboardService;
        this.activityWriter = activityWriter;
    }

    @GET
    @Deprecated
    @Timed
    @ApiOperation(value="Get a list of all dashboards and all configurations of their widgets.")
    @Produces(value={"application/json"})
    public DashboardList list() {
        ArrayList dashboards = Lists.newArrayList();
        for (Dashboard dashboard : this.dashboardService.all()) {
            if (!this.isPermitted("dashboards:read", dashboard.getId())) continue;
            dashboards.add(dashboard.asMap());
        }
        return DashboardList.create(dashboards.size(), dashboards);
    }

    @GET
    @Deprecated
    @Timed
    @ApiOperation(value="Get a single dashboards and all configurations of its widgets.")
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @Produces(value={"application/json"})
    public Map<String, Object> get(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws NotFoundException {
        this.checkPermission("dashboards:read", dashboardId);
        return this.dashboardService.load(dashboardId).asMap();
    }

    @DELETE
    @Deprecated
    @Timed
    @ApiOperation(value="Delete a dashboard and all its widgets")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @AuditEvent(type="server:dashboard:delete")
    public void delete(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws NotFoundException, ValidationException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        this.dashboardService.destroy(dashboard);
        String msg = "Deleted dashboard <" + dashboard.getId() + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, LegacyDashboardsResource.class));
    }
}

