/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.resources.search.responses.;
import org.graylog2.rest.resources.search.responses.SearchDecorationStats;
import org.joda.time.DateTime;

@JsonAutoDetect
@AutoValue
public abstract class SearchResponse {
    @JsonProperty
    public abstract String query();

    @JsonProperty
    public abstract String builtQuery();

    @JsonProperty
    public abstract Set<IndexRangeSummary> usedIndices();

    @JsonProperty
    public abstract List<ResultMessageSummary> messages();

    @JsonProperty
    public abstract Set<String> fields();

    @JsonProperty
    public abstract long time();

    @JsonProperty
    public abstract long totalResults();

    @JsonProperty
    public abstract DateTime from();

    @JsonProperty
    public abstract DateTime to();

    @JsonProperty
    @Nullable
    public abstract SearchDecorationStats decorationStats();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new .AutoValue_SearchResponse.Builder();
    }

    public static SearchResponse create(String query, String builtQuery, Set<IndexRangeSummary> usedIndices, List<ResultMessageSummary> messages, Set<String> fields, long time, long totalResults, DateTime from, DateTime to) {
        return SearchResponse.builder().query(query).builtQuery(builtQuery).usedIndices(usedIndices).messages(messages).fields(fields).time(time).totalResults(totalResults).from(from).to(to).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder query(String var1);

        public abstract Builder builtQuery(String var1);

        public abstract Builder usedIndices(Set<IndexRangeSummary> var1);

        public abstract Builder messages(List<ResultMessageSummary> var1);

        public abstract Builder fields(Set<String> var1);

        public abstract Builder time(long var1);

        public abstract Builder totalResults(long var1);

        public abstract Builder from(DateTime var1);

        public abstract Builder to(DateTime var1);

        public abstract Builder decorationStats(SearchDecorationStats var1);

        public abstract SearchResponse build();
    }
}

