/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.nio.file.Path;
import org.graylog2.plugin.KafkaJournalConfiguration;
import org.graylog2.rest.resources.system.responses.AutoValue_KafkaJournalConfigurationSummary;
import org.joda.time.Duration;

@JsonAutoDetect
@AutoValue
public abstract class KafkaJournalConfigurationSummary {
    private static final String FIELD_DIRECTORY = "directory";
    private static final String FIELD_SEGMENT_SIZE = "segment_size";
    private static final String FIELD_SEGMENT_AGE = "segment_age";
    private static final String FIELD_MAX_SIZE = "max_size";
    private static final String FIELD_MAX_AGE = "max_age";
    private static final String FIELD_FLUSH_INTERVAL = "flush_interval";
    private static final String FIELD_FLUSH_AGE = "flush_age";

    @JsonProperty(value="directory")
    public abstract Path directory();

    @JsonProperty(value="segment_size")
    public abstract long segmentSize();

    @JsonProperty(value="segment_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public abstract Duration segmentAge();

    @JsonProperty(value="max_size")
    public abstract long maxSize();

    @JsonProperty(value="max_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public abstract Duration maxAge();

    @JsonProperty(value="flush_interval")
    public abstract long flushInterval();

    @JsonProperty(value="flush_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public abstract Duration flushAge();

    public static KafkaJournalConfigurationSummary of(KafkaJournalConfiguration config) {
        return KafkaJournalConfigurationSummary.create(config.getMessageJournalDir(), config.getMessageJournalSegmentSize().toBytes(), config.getMessageJournalSegmentAge(), config.getMessageJournalMaxSize().toBytes(), config.getMessageJournalMaxAge(), config.getMessageJournalFlushInterval(), config.getMessageJournalFlushAge());
    }

    @JsonCreator
    public static KafkaJournalConfigurationSummary create(@JsonProperty(value="directory") Path directory, @JsonProperty(value="segment_size") long segmentSize, @JsonProperty(value="segment_age") Duration segmentAge, @JsonProperty(value="max_size") long maxSize, @JsonProperty(value="max_age") Duration maxAge, @JsonProperty(value="flush_interval") long flushInterval, @JsonProperty(value="flush_age") Duration flushAge) {
        return new AutoValue_KafkaJournalConfigurationSummary(directory, segmentSize, segmentAge, maxSize, maxAge, flushInterval, flushAge);
    }
}

