/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.security.AccessToken;
import org.graylog2.security.AccessTokenCipher;
import org.graylog2.security.AccessTokenImpl;
import org.graylog2.security.AccessTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenServiceImpl
extends PersistedServiceImpl
implements AccessTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenServiceImpl.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private final AccessTokenCipher cipher;

    @Inject
    public AccessTokenServiceImpl(MongoConnection mongoConnection, AccessTokenCipher accessTokenCipher) {
        super(mongoConnection);
        this.cipher = accessTokenCipher;
        this.collection(AccessTokenImpl.class).createIndex((DBObject)new BasicDBObject("token_type", (Object)1));
    }

    @Override
    public AccessToken load(String token) {
        BasicDBObject query = new BasicDBObject();
        query.put("token", (Object)this.cipher.encrypt(token));
        List<DBObject> objects = this.query(AccessTokenImpl.class, (DBObject)query);
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.size() > 1) {
            LOG.error("Multiple access tokens found, this is a serious bug.");
            throw new IllegalStateException("Access tokens collection has no unique index!");
        }
        return this.fromDBObject(objects.get(0));
    }

    @Override
    @Nullable
    public AccessToken loadById(String id) {
        try {
            DBObject dbObject = this.get(AccessTokenImpl.class, id);
            if (dbObject != null) {
                return this.fromDBObject(dbObject);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Couldn't load access token", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<AccessToken> loadAll(String username) {
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> objects = this.query(AccessTokenImpl.class, (DBObject)query);
        return objects.stream().map(this::fromDBObject).collect(Collectors.toList());
    }

    @Override
    public AccessToken create(String username, String name) {
        AccessTokenImpl accessToken;
        HashMap fields = Maps.newHashMap();
        String id = null;
        int iterations = 0;
        do {
            String token = new BigInteger(256, RANDOM).toString(32);
            fields.put("token", token);
            fields.put("username", username);
            fields.put("NAME", name);
            fields.put("last_access", Tools.dateTimeFromDouble(0.0));
            accessToken = new AccessTokenImpl(fields);
            try {
                id = this.saveWithoutValidation(this.encrypt(accessToken));
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        } while (iterations++ < 10 && id == null);
        if (id == null) {
            throw new IllegalStateException("Could not create unique access token, tried 10 times. This is bad.");
        }
        return accessToken;
    }

    @Override
    public void touch(AccessToken accessToken) throws ValidationException {
        accessToken.getFields().put("last_access", Tools.nowUTC());
        this.save(accessToken);
    }

    @Override
    public String save(AccessToken accessToken) throws ValidationException {
        this.collection(AccessTokenImpl.class).createIndex((DBObject)new BasicDBObject("token", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        return super.save(this.encrypt(accessToken));
    }

    @Override
    public int deleteAllForUser(String username) {
        LOG.debug("Deleting all access tokens of user \"{}\"", (Object)username);
        DBObject query = BasicDBObjectBuilder.start((String)"username", (Object)username).get();
        int result = this.destroy(query, "access_tokens");
        LOG.debug("Deleted {} access tokens of user \"{}\"", (Object)result, (Object)username);
        return result;
    }

    private AccessTokenImpl fromDBObject(DBObject dbObject) {
        HashMap<String, Object> fields = new HashMap<String, Object>(dbObject.toMap());
        String ciphertext = (String)fields.get("token");
        if (StringUtils.isNotBlank((CharSequence)ciphertext)) {
            fields.put("token", this.cipher.decrypt(ciphertext));
            fields.remove("token_type");
        }
        ObjectId id = (ObjectId)dbObject.get("_id");
        return new AccessTokenImpl(id, fields);
    }

    private AccessTokenImpl encrypt(AccessToken token) {
        HashMap<String, Object> fields = new HashMap<String, Object>(token.getFields());
        String cleartext = (String)fields.get("token");
        if (StringUtils.isNotBlank((CharSequence)cleartext)) {
            fields.put("token", this.cipher.encrypt(cleartext));
            fields.put("token_type", AccessTokenImpl.Type.AES_SIV.getIntValue());
        }
        if (token.getId() == null) {
            return new AccessTokenImpl(fields);
        }
        return new AccessTokenImpl(new ObjectId(token.getId()), fields);
    }
}

