/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import java.io.Serializable;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.security.SessionIdToken;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(SessionAuthenticator.class);
    public static final String NAME = "mongodb-session";
    public static final String X_GRAYLOG_NO_SESSION_EXTENSION = "X-Graylog-No-Session-Extension";
    private final UserService userService;

    @Inject
    SessionAuthenticator(UserService userService) {
        this.userService = userService;
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setAuthenticationTokenClass(SessionIdToken.class);
        this.setCachingEnabled(false);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        MultivaluedMap requestHeaders;
        SessionIdToken sessionIdToken = (SessionIdToken)token;
        Subject subject = new Subject.Builder().sessionId((Serializable)((Object)sessionIdToken.getSessionId())).buildSubject();
        Session session = subject.getSession(false);
        if (session == null) {
            LOG.debug("Invalid session. Either it has expired or did not exist.");
            return null;
        }
        Object username = subject.getPrincipal();
        User user = this.userService.load(String.valueOf(username));
        if (user == null) {
            LOG.debug("No user named {} found for session", username);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found session for user name {}", username);
        }
        if ((requestHeaders = (MultivaluedMap)ThreadContext.get((Object)"REQUEST_HEADERS")) != null && !"true".equalsIgnoreCase((String)requestHeaders.getFirst((Object)X_GRAYLOG_NO_SESSION_EXTENSION))) {
            session.touch();
        } else {
            LOG.debug("Not extending session because the request indicated not to.");
        }
        ThreadContext.bind((Subject)subject);
        return new SimpleAccount((Object)user.getName(), null, "session authenticator");
    }
}

