/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.LoggerFactory;

@Singleton
public class ProxiedRequestsExecutorService
implements Provider<ExecutorService> {
    private final int proxiedRequestsMaxThreads;

    @Inject
    public ProxiedRequestsExecutorService(@Named(value="proxied_requests_thread_pool_size") int proxiedRequestsMaxThreads) {
        this.proxiedRequestsMaxThreads = proxiedRequestsMaxThreads;
    }

    public ExecutorService get() {
        return Executors.newFixedThreadPool(this.proxiedRequestsMaxThreads, new ThreadFactoryBuilder().setNameFormat("proxied-requests-pool-%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new Tools.LogUncaughtExceptionHandler(LoggerFactory.getLogger((String)ProxiedResource.class.getName()))).build());
    }
}

