/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.documentation;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.plugin.inject.RestControllerPackage;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.plugins.PluginRestResourceClasses;
import org.graylog2.shared.rest.documentation.generator.Generator;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Documentation", description="Documentation of this API in JSON format.")
@Path(value="/api-docs")
public class DocumentationResource
extends RestResource {
    private final Generator generator;
    private final HttpConfiguration httpConfiguration;

    @Inject
    public DocumentationResource(HttpConfiguration httpConfiguration, Set<RestControllerPackage> restControllerPackages, ObjectMapper objectMapper, PluginRestResourceClasses pluginRestResourceClasses) {
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration, "httpConfiguration");
        ImmutableSet.Builder packageNames = ImmutableSet.builder().addAll((Iterable)restControllerPackages.stream().map(RestControllerPackage::name).collect(Collectors.toList()));
        HashMap pluginRestControllerMapping = new HashMap();
        for (Map.Entry<String, Set<Class<? extends PluginRestResource>>> entry : pluginRestResourceClasses.getMap().entrySet()) {
            String pluginPackage = entry.getKey();
            packageNames.add((Object)pluginPackage);
            for (Class<? extends PluginRestResource> pluginRestResource : entry.getValue()) {
                pluginRestControllerMapping.put(pluginRestResource, pluginPackage);
            }
        }
        this.generator = new Generator((Set<String>)packageNames.build(), pluginRestControllerMapping, "/plugins", objectMapper);
    }

    @GET
    @Timed
    @ApiOperation(value="Get API documentation")
    @Produces(value={"application/json"})
    public Response overview() {
        return this.buildSuccessfulCORSResponse(this.generator.generateOverview());
    }

    @GET
    @Timed
    @ApiOperation(value="Get API documentation with cluster global URI path")
    @Produces(value={"application/json"})
    @Path(value="/global")
    public Response globalOverview() {
        return this.buildSuccessfulCORSResponse(this.generator.generateOverview());
    }

    @GET
    @Timed
    @ApiOperation(value="Get detailed API documentation of a single resource")
    @Produces(value={"application/json"})
    @Path(value="/{route: .+}")
    public Response route(@ApiParam(name="route", value="Route to fetch. For example /system", required=true) @PathParam(value="route") String route, @Context HttpHeaders httpHeaders) {
        URI baseUri;
        if (route.startsWith("global")) {
            route = route.replace("global", "");
            baseUri = RestTools.buildExternalUri((MultivaluedMap<String, String>)httpHeaders.getRequestHeaders(), this.httpConfiguration.getHttpExternalUri()).resolve("api/");
        } else {
            baseUri = this.httpConfiguration.getHttpPublishUri().resolve("api/");
        }
        return this.buildSuccessfulCORSResponse(this.generator.generateForRoute(route, baseUri.toString()));
    }

    private Response buildSuccessfulCORSResponse(Map<String, Object> result) {
        return Response.ok(result).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET").header("Access-Control-Allow-Headers", (Object)"Content-Type, api_key, Authorization").build();
    }
}

