/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.security.ActorAwareAuthenticationToken;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCreator {
    private static final Logger log = LoggerFactory.getLogger(SessionCreator.class);
    private final UserService userService;
    private final AuditEventSender auditEventSender;

    @Inject
    public SessionCreator(UserService userService, AuditEventSender auditEventSender) {
        this.userService = userService;
        this.auditEventSender = auditEventSender;
    }

    public Optional<Session> create(@Nullable String currentSessionId, String host, ActorAwareAuthenticationToken authToken) {
        String previousSessionId = (String)StringUtils.defaultIfBlank((CharSequence)currentSessionId, null);
        Subject subject = new Subject.Builder().sessionId((Serializable)((Object)previousSessionId)).host(host).buildSubject();
        ThreadContext.bind((Subject)subject);
        try {
            Session session = subject.getSession();
            subject.login((AuthenticationToken)authToken);
            String username = subject.getPrincipal().toString();
            User user = this.userService.load(username);
            if (user != null) {
                long timeoutInMillis = user.getSessionTimeoutMs();
                session.setTimeout(timeoutInMillis);
            } else {
                session.setTimeout(TimeUnit.HOURS.toMillis(8L));
            }
            session.touch();
            ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
            ImmutableMap auditEventContext = ImmutableMap.of((Object)"session_id", (Object)session.getId(), (Object)"remote_address", (Object)host);
            this.auditEventSender.success(AuditActor.user(username), "server:session:create", (Map<String, Object>)auditEventContext);
            return Optional.of(session);
        }
        catch (AuthenticationException e) {
            log.info("Invalid credentials in session create request. Actor: \"{}\"", (Object)authToken.getActor().urn());
            ImmutableMap auditEventContext = ImmutableMap.of((Object)"remote_address", (Object)host);
            this.auditEventSender.failure(authToken.getActor(), "server:session:create", (Map<String, Object>)auditEventContext);
            return Optional.empty();
        }
    }
}

