/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.filter.ActiveSidecarFilter;
import org.graylog.plugins.sidecar.filter.AdministrationFilter;
import org.graylog.plugins.sidecar.filter.AdministrationFiltersFactory;
import org.graylog.plugins.sidecar.mapper.SidecarStatusMapper;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.CollectorActions;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog.plugins.sidecar.rest.requests.AdministrationRequest;
import org.graylog.plugins.sidecar.rest.requests.BulkActionRequest;
import org.graylog.plugins.sidecar.rest.requests.BulkActionsRequest;
import org.graylog.plugins.sidecar.rest.resources.SidecarResource;
import org.graylog.plugins.sidecar.rest.responses.SidecarListResponse;
import org.graylog.plugins.sidecar.services.ActionService;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog.plugins.sidecar.system.SidecarConfiguration;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Sidecar/Administration", description="Administrate sidecars")
@Path(value="/sidecar/administration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class AdministrationResource
extends RestResource
implements PluginRestResource {
    private final SidecarService sidecarService;
    private final ConfigurationService configurationService;
    private final CollectorService collectorService;
    private final ActionService actionService;
    private final SearchQueryParser searchQueryParser;
    private final AdministrationFiltersFactory administrationFiltersFactory;
    private final ActiveSidecarFilter activeSidecarFilter;
    private final SidecarStatusMapper sidecarStatusMapper;

    @Inject
    public AdministrationResource(SidecarService sidecarService, ConfigurationService configurationService, CollectorService collectorService, ActionService actionService, AdministrationFiltersFactory administrationFiltersFactory, ClusterConfigService clusterConfigService, SidecarStatusMapper sidecarStatusMapper) {
        SidecarConfiguration sidecarConfiguration = clusterConfigService.getOrDefault(SidecarConfiguration.class, SidecarConfiguration.defaultConfiguration());
        this.sidecarService = sidecarService;
        this.configurationService = configurationService;
        this.collectorService = collectorService;
        this.actionService = actionService;
        this.administrationFiltersFactory = administrationFiltersFactory;
        this.sidecarStatusMapper = sidecarStatusMapper;
        this.activeSidecarFilter = new ActiveSidecarFilter(sidecarConfiguration.sidecarInactiveThreshold());
        this.searchQueryParser = new SearchQueryParser("node_name", (Map<String, SearchQueryField>)SidecarResource.SEARCH_FIELD_MAPPING);
    }

    @POST
    @Timed
    @ApiOperation(value="Lists existing Sidecar registrations including compatible sidecars using pagination")
    @RequiresPermissions(value={"sidecars:read", "sidecar_collectors:read", "sidecar_collector_configurations:read"})
    @NoAuditEvent(value="this is not changing any data")
    public SidecarListResponse administration(@ApiParam(name="JSON body", required=true) @Valid @NotNull AdministrationRequest request) {
        SearchQuery searchQuery;
        String sort = "node_name";
        String order = "asc";
        String mappedQuery = this.sidecarStatusMapper.replaceStringStatusSearchQuery(request.query());
        try {
            searchQuery = this.searchQueryParser.parse(mappedQuery);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        long total = this.sidecarService.count();
        Optional<Predicate<Sidecar>> filters = this.administrationFiltersFactory.getFilters(request.filters());
        List<Collector> collectors = this.getCollectors(request.filters());
        PaginatedList<Sidecar> sidecars = this.sidecarService.findPaginated(searchQuery, filters.orElse(null), request.page(), request.perPage(), "node_name", "asc");
        List<SidecarSummary> sidecarSummaries = this.sidecarService.toSummaryList((List<Sidecar>)((Object)sidecars), this.activeSidecarFilter);
        List<SidecarSummary> summariesWithCollectors = sidecarSummaries.stream().map(collector -> {
            List<String> compatibleCollectors = collectors.stream().filter(c -> c.nodeOperatingSystem().equalsIgnoreCase(collector.nodeDetails().operatingSystem())).map(Collector::id).collect(Collectors.toList());
            return collector.toBuilder().collectors(compatibleCollectors).build();
        }).filter(collectorSummary -> !filters.isPresent() || collectorSummary.collectors().size() > 0).collect(Collectors.toList());
        return SidecarListResponse.create(request.query(), sidecars.pagination(), total, false, "node_name", "asc", summariesWithCollectors, request.filters());
    }

    @PUT
    @Timed
    @Path(value="/action")
    @RequiresPermissions(value={"sidecars:update"})
    @ApiOperation(value="Set collector actions in bulk")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied action is not valid.")})
    @AuditEvent(type="sidecar:action:update")
    public Response setAction(@ApiParam(name="JSON body", required=true) @Valid @NotNull BulkActionsRequest request) {
        for (BulkActionRequest bulkActionRequest : request.collectors()) {
            List<CollectorAction> actions = bulkActionRequest.collectorIds().stream().map(collectorId -> CollectorAction.create(collectorId, request.action())).collect(Collectors.toList());
            CollectorActions collectorActions = this.actionService.fromRequest(bulkActionRequest.sidecarId(), actions);
            this.actionService.saveAction(collectorActions);
        }
        return Response.accepted().build();
    }

    private List<Collector> getCollectors(Map<String, String> filters) {
        Configuration configuration;
        String collectorKey = AdministrationFilter.Type.COLLECTOR.toString().toLowerCase(Locale.ENGLISH);
        String configurationKey = AdministrationFilter.Type.CONFIGURATION.toString().toLowerCase(Locale.ENGLISH);
        ArrayList<String> collectorIds = new ArrayList<String>();
        if (filters.containsKey(collectorKey)) {
            collectorIds.add(filters.get(collectorKey));
        }
        if (filters.containsKey(configurationKey) && !collectorIds.contains((configuration = this.configurationService.find(filters.get(configurationKey))).collectorId())) {
            collectorIds.add(configuration.collectorId());
        }
        switch (collectorIds.size()) {
            case 0: {
                return this.collectorService.all();
            }
            case 1: {
                return ImmutableList.of((Object)this.collectorService.find((String)collectorIds.get(0)));
            }
        }
        return new ArrayList<Collector>();
    }
}

