/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import org.graylog.plugins.views.search.elasticsearch.AutoValue_ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.BackendQuery;

@JsonTypeName(value="elasticsearch")
@JsonDeserialize(builder=AutoValue_ElasticsearchQueryString.Builder.class)
@AutoValue
public abstract class ElasticsearchQueryString
implements BackendQuery {
    public static final String NAME = "elasticsearch";

    public static ElasticsearchQueryString empty() {
        return ElasticsearchQueryString.builder().queryString("").build();
    }

    @Override
    public abstract String type();

    @JsonProperty
    public abstract String queryString();

    @JsonIgnore
    public boolean isEmpty() {
        String trimmed = this.queryString().trim();
        return trimmed.equals("") || trimmed.equals("*");
    }

    public static Builder builder() {
        return new AutoValue_ElasticsearchQueryString.Builder().type(NAME);
    }

    abstract Builder toBuilder();

    public ElasticsearchQueryString concatenate(ElasticsearchQueryString other) {
        String thisQueryString = Strings.nullToEmpty((String)this.queryString()).trim();
        String otherQueryString = Strings.nullToEmpty((String)other.queryString()).trim();
        StringBuilder finalStringBuilder = new StringBuilder(thisQueryString);
        if (!thisQueryString.isEmpty() && !otherQueryString.isEmpty()) {
            finalStringBuilder.append(" AND ");
        }
        if (!otherQueryString.isEmpty()) {
            finalStringBuilder.append(otherQueryString);
        }
        return this.toBuilder().queryString(finalStringBuilder.toString()).build();
    }

    public String toString() {
        return this.type() + ": " + this.queryString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder queryString(String var1);

        public abstract ElasticsearchQueryString build();
    }
}

