/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.QueryStringDecorator;

public class QueryStringDecorators
implements QueryStringDecorator {
    private final Set<QueryStringDecorator> queryDecorators;

    @Inject
    public QueryStringDecorators(Set<QueryStringDecorator> queryDecorators) {
        this.queryDecorators = queryDecorators;
    }

    @Override
    public String decorate(String queryString, SearchJob job, Query query, Set<QueryResult> results) {
        return this.queryDecorators.isEmpty() ? queryString : this.queryDecorators.stream().reduce(queryString, (prev, decorator) -> decorator.decorate((String)prev, job, query, results), String::concat);
    }

    public static class Fake
    extends QueryStringDecorators {
        public Fake() {
            super(Collections.emptySet());
        }
    }
}

