/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.security.Capability;
import org.graylog.security.CapabilityDescriptor;

@Singleton
public class BuiltinCapabilities {
    private static ImmutableMap<Capability, CapabilityDescriptor> CAPABILITIES;

    @Inject
    public BuiltinCapabilities() {
        CAPABILITIES = ImmutableMap.builder().put((Object)Capability.VIEW, (Object)CapabilityDescriptor.create(Capability.VIEW, "Viewer", (Set<String>)ImmutableSet.of((Object)"streams:read", (Object)"dashboards:read", (Object)"view:read", (Object)"eventdefinitions:read", (Object)"eventnotifications:read"))).put((Object)Capability.MANAGE, (Object)CapabilityDescriptor.create(Capability.MANAGE, "Manager", (Set<String>)ImmutableSet.of((Object)"streams:read", (Object)"streams:edit", (Object)"streams:changestate", (Object)"dashboards:read", (Object)"dashboards:edit", (Object)"view:read", (Object[])new String[]{"view:edit", "eventdefinitions:read", "eventdefinitions:edit", "eventnotifications:read", "eventnotifications:edit"}))).put((Object)Capability.OWN, (Object)CapabilityDescriptor.create(Capability.OWN, "Owner", (Set<String>)ImmutableSet.of((Object)"entity:own", (Object)"streams:read", (Object)"streams:edit", (Object)"streams:changestate", (Object)"dashboards:read", (Object)"dashboards:edit", (Object[])new String[]{"view:read", "view:edit", "view:delete", "eventdefinitions:read", "eventdefinitions:edit", "eventdefinitions:delete", "eventnotifications:read", "eventnotifications:edit", "eventnotifications:delete"}))).build();
    }

    public static ImmutableSet<CapabilityDescriptor> allSharingCapabilities() {
        return ImmutableSet.of((Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.VIEW)), (Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.MANAGE)), (Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.OWN)));
    }

    public Optional<CapabilityDescriptor> get(Capability capability) {
        return Optional.ofNullable((CapabilityDescriptor)CAPABILITIES.get((Object)capability));
    }
}

