/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.Capability;
import org.graylog.security.GrantDTO;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.plugin.database.users.User;
import org.mongojack.DBQuery;

public class DBGrantService
extends PaginatedDbService<GrantDTO> {
    public static final String COLLECTION_NAME = "grants";
    private final GRNRegistry grnRegistry;

    @Inject
    public DBGrantService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, GRNRegistry grnRegistry) {
        super(mongoConnection, mapper, GrantDTO.class, COLLECTION_NAME);
        this.grnRegistry = grnRegistry;
        this.db.createIndex((DBObject)new BasicDBObject("grantee", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("target", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("grantee", (Object)1).append("capability", (Object)1).append("target", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject("grantee", (Object)1).append("target", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        MongoCollection collection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        collection.updateMany(Filters.eq((String)"capability", (Object)"grn::::capability:54e3deadbeefdeadbeef0000"), Updates.set((String)"capability", (Object)Capability.VIEW.toId()));
        collection.updateMany(Filters.eq((String)"capability", (Object)"grn::::capability:54e3deadbeefdeadbeef0001"), Updates.set((String)"capability", (Object)Capability.MANAGE.toId()));
        collection.updateMany(Filters.eq((String)"capability", (Object)"grn::::capability:54e3deadbeefdeadbeef0002"), Updates.set((String)"capability", (Object)Capability.OWN.toId()));
    }

    public ImmutableSet<GrantDTO> getForGranteesOrGlobal(Set<GRN> grantees) {
        return (ImmutableSet)this.streamQuery(DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"grantee", grantees), DBQuery.is((String)"grantee", (Object)GRNRegistry.GLOBAL_USER_GRN.toString())})).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<GrantDTO> getForGrantee(GRN grantee) {
        return (ImmutableSet)this.streamQuery(DBQuery.is((String)"grantee", (Object)grantee)).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<GrantDTO> getForGranteeWithCapability(GRN grantee, Capability capability) {
        return (ImmutableSet)this.streamQuery(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"grantee", (Object)grantee), DBQuery.is((String)"capability", (Object)((Object)capability))})).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<GrantDTO> getForGranteesOrGlobalWithCapability(Set<GRN> grantees, Capability capability) {
        return (ImmutableSet)this.streamQuery(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"grantee", grantees), DBQuery.is((String)"grantee", (Object)GRNRegistry.GLOBAL_USER_GRN.toString())}), DBQuery.is((String)"capability", (Object)((Object)capability))})).collect(ImmutableSet.toImmutableSet());
    }

    public List<GrantDTO> getForTargetAndGrantee(GRN target, GRN grantee) {
        return this.getForTargetAndGrantees(target, (Set<GRN>)ImmutableSet.of((Object)grantee));
    }

    public List<GrantDTO> getForTargetAndGrantees(GRN target, Set<GRN> grantees) {
        return this.db.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"target", (Object)target), DBQuery.in((String)"grantee", grantees)})).toArray();
    }

    public GrantDTO create(GrantDTO grantDTO, @Nullable User currentUser) {
        return this.create(grantDTO, Objects.requireNonNull(currentUser, "currentUser cannot be null").getName());
    }

    public GrantDTO create(GrantDTO grantDTO, String creatorUsername) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)creatorUsername), (Object)"creatorUsername cannot be null or empty");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return this.save(grantDTO.toBuilder().createdBy(creatorUsername).createdAt(now).updatedBy(creatorUsername).updatedAt(now).build());
    }

    public GrantDTO create(GRN grantee, Capability capability, GRN target, String creatorUsername) {
        Preconditions.checkArgument((grantee != null ? 1 : 0) != 0, (Object)"grantee cannot be null");
        Preconditions.checkArgument((capability != null ? 1 : 0) != 0, (Object)"capability cannot be null");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target cannot be null");
        return this.create(GrantDTO.of(grantee, capability, target), creatorUsername);
    }

    public GrantDTO ensure(GRN grantee, Capability capability, GRN target, String creatorUsername) {
        List<GrantDTO> existingGrants = this.getForTargetAndGrantee(target, grantee);
        if (existingGrants.isEmpty()) {
            return this.create(grantee, capability, target, creatorUsername);
        }
        Preconditions.checkState((existingGrants.size() == 1 ? 1 : 0) != 0);
        GrantDTO grantDTO = existingGrants.get(0);
        if (capability.priority() > grantDTO.capability().priority()) {
            GrantDTO grantUpdate = grantDTO.toBuilder().capability(capability).build();
            return this.save(grantUpdate);
        }
        return grantDTO;
    }

    public GrantDTO update(GrantDTO updatedGrant, @Nullable User currentUser) {
        GrantDTO existingGrant = (GrantDTO)this.get(updatedGrant.id()).orElseThrow(() -> new IllegalArgumentException("Couldn't find grant with ID " + updatedGrant.id()));
        return this.save(existingGrant.toBuilder().grantee(updatedGrant.grantee()).capability(updatedGrant.capability()).target(updatedGrant.target()).updatedBy(Objects.requireNonNull(currentUser, "currentUser cannot be null").getName()).updatedAt(ZonedDateTime.now(ZoneOffset.UTC)).build());
    }

    public ImmutableSet<GrantDTO> getAll() {
        try (Stream stream = this.streamAll();){
            ImmutableSet immutableSet = (ImmutableSet)stream.collect(ImmutableSet.toImmutableSet());
            return immutableSet;
        }
    }

    public List<GrantDTO> getForTarget(GRN target) {
        return this.db.find(DBQuery.is((String)"target", (Object)target.toString())).toArray();
    }

    public int deleteForGrantee(GRN grantee) {
        return this.db.remove(DBQuery.is((String)"grantee", (Object)grantee.toString())).getN();
    }

    public int deleteForTarget(GRN target) {
        return this.db.remove(DBQuery.is((String)"target", (Object)target.toString())).getN();
    }

    public List<GrantDTO> getForTargetExcludingGrantee(GRN target, GRN grantee) {
        return this.db.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"target", (Object)target.toString()), DBQuery.notEquals((String)"grantee", (Object)grantee.toString())})).toArray();
    }

    public Map<GRN, Set<GRN>> getOwnersForTargets(Collection<GRN> targets) {
        return this.db.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"target", targets), DBQuery.is((String)"capability", (Object)((Object)Capability.OWN))})).toArray().stream().collect(Collectors.groupingBy(GrantDTO::target, Collectors.mapping(GrantDTO::grantee, Collectors.toSet())));
    }

    public boolean hasGrantFor(GRN grantee, Capability capability, GRN target) {
        return this.db.findOne(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"grantee", (Object)grantee), DBQuery.is((String)"capability", (Object)((Object)capability)), DBQuery.is((String)"target", (Object)target)})) != null;
    }
}

