/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.backend;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog.security.authservice.UserDetails;
import org.graylog.security.authservice.backend.ADAuthServiceBackendConfig;
import org.graylog.security.authservice.ldap.LDAPUser;
import org.graylog.security.authservice.ldap.UnboundLDAPConfig;
import org.graylog.security.authservice.ldap.UnboundLDAPConnector;
import org.graylog.security.authservice.test.AuthServiceBackendTestResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADAuthServiceBackend
implements AuthServiceBackend {
    public static final String TYPE_NAME = "active-directory";
    private static final Logger LOG = LoggerFactory.getLogger(ADAuthServiceBackend.class);
    public static final String AD_OBJECT_GUID = "objectGUID";
    public static final String AD_SAM_ACCOUNT_NAME = "sAMAccountName";
    public static final String AD_USER_PRINCIPAL_NAME = "userPrincipalName";
    public static final String AD_DISPLAY_NAME = "displayName";
    public static final String AD_CN = "cn";
    public static final Filter AD_DEFAULT_USER_SEARCH_PATTERN = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectClass", (String)"user"), Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"userPrincipalName", (String)"{0}"), Filter.createEqualityFilter((String)"sAMAccountName", (String)"{0}")})});
    private final UnboundLDAPConnector ldapConnector;
    private final AuthServiceBackendDTO backend;
    private final ADAuthServiceBackendConfig config;

    @Inject
    public ADAuthServiceBackend(UnboundLDAPConnector ldapConnector, @Assisted AuthServiceBackendDTO backend) {
        this.ldapConnector = ldapConnector;
        this.backend = backend;
        this.config = (ADAuthServiceBackendConfig)backend.config();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<UserDetails> authenticateAndProvision(AuthServiceCredentials authCredentials, ProvisionerService provisionerService) {
        try (LDAPConnection connection = this.ldapConnector.connect(this.config.getLDAPConnectorConfig());){
            if (connection == null) {
                Optional<UserDetails> optional = Optional.empty();
                return optional;
            }
            Optional<LDAPUser> optionalUser = this.findUser(connection, authCredentials);
            if (!optionalUser.isPresent()) {
                LOG.debug("User <{}> not found in Active Directory", (Object)authCredentials.username());
                Optional<UserDetails> optional = Optional.empty();
                return optional;
            }
            LDAPUser userEntry = optionalUser.get();
            if (!authCredentials.isAuthenticated() && !this.isAuthenticated(connection, userEntry, authCredentials)) {
                LOG.debug("Invalid credentials for user <{}> (DN: {})", (Object)authCredentials.username(), (Object)userEntry.dn());
                Optional<UserDetails> optional = Optional.empty();
                return optional;
            }
            UserDetails userDetails = provisionerService.provision(provisionerService.newDetails(this).authServiceType(this.backendType()).authServiceId(this.backendId()).base64AuthServiceUid(userEntry.base64UniqueId()).username(userEntry.username()).fullName(userEntry.fullName()).email(userEntry.email()).defaultRoles(this.backend.defaultRoles()).build());
            Optional<UserDetails> optional = Optional.of(userDetails);
            return optional;
        }
        catch (GeneralSecurityException e) {
            LOG.error("Error setting up TLS connection", (Throwable)e);
            return Optional.empty();
        }
        catch (LDAPException e) {
            LOG.error("ActiveDirectory error", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean isAuthenticated(LDAPConnection connection, LDAPUser user, AuthServiceCredentials authCredentials) throws LDAPException {
        return this.ldapConnector.authenticate(connection, user.entry().nonBlankAttribute(AD_USER_PRINCIPAL_NAME), authCredentials.password());
    }

    private Optional<LDAPUser> findUser(LDAPConnection connection, AuthServiceCredentials authCredentials) throws LDAPException {
        UnboundLDAPConfig searchConfig = UnboundLDAPConfig.builder().userSearchBase(this.config.userSearchBase()).userSearchPattern(this.config.userSearchPattern()).userUniqueIdAttribute(AD_OBJECT_GUID).userNameAttribute(this.config.userNameAttribute()).userFullNameAttribute(this.config.userFullNameAttribute()).build();
        return this.ldapConnector.searchUserByPrincipal(connection, searchConfig, authCredentials.username());
    }

    @Override
    public String backendType() {
        return TYPE_NAME;
    }

    @Override
    public String backendId() {
        return this.backend.id();
    }

    @Override
    public String backendTitle() {
        return this.backend.title();
    }

    @Override
    public AuthServiceBackendDTO prepareConfigUpdate(AuthServiceBackendDTO existingBackend, AuthServiceBackendDTO newBackend) {
        ADAuthServiceBackendConfig newConfig = (ADAuthServiceBackendConfig)newBackend.config();
        if (newConfig.systemUserPassword().isDeleteValue()) {
            return newBackend.toBuilder().config(newConfig.toBuilder().systemUserPassword(EncryptedValue.createUnset()).build()).build();
        }
        if (newConfig.systemUserPassword().isKeepValue()) {
            ADAuthServiceBackendConfig existingConfig = (ADAuthServiceBackendConfig)existingBackend.config();
            return newBackend.toBuilder().config(newConfig.toBuilder().systemUserPassword(existingConfig.systemUserPassword()).build()).build();
        }
        return newBackend;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthServiceBackendTestResult testConnection(@Nullable AuthServiceBackendDTO existingBackendConfig) {
        ADAuthServiceBackendConfig testConfig = this.buildTestConfig(existingBackendConfig);
        try (LDAPConnection connection = this.ldapConnector.connect(testConfig.getLDAPConnectorConfig());){
            if (connection == null) {
                AuthServiceBackendTestResult authServiceBackendTestResult2 = AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + testConfig.servers());
                return authServiceBackendTestResult2;
            }
            AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createSuccess("Successfully connected to " + testConfig.servers());
            return authServiceBackendTestResult;
        }
        catch (Exception e) {
            return AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + testConfig.servers(), Collections.singletonList(e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthServiceBackendTestResult testLogin(AuthServiceCredentials credentials, @Nullable AuthServiceBackendDTO existingBackendConfig) {
        ADAuthServiceBackendConfig testConfig = this.buildTestConfig(existingBackendConfig);
        try (LDAPConnection connection = this.ldapConnector.connect(testConfig.getLDAPConnectorConfig());){
            if (connection == null) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("Couldn't establish connection to " + testConfig.servers());
                return authServiceBackendTestResult;
            }
            Optional<LDAPUser> user = this.findUser(connection, credentials);
            if (!user.isPresent()) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("User <" + credentials.username() + "> doesn't exist", this.createTestResult(testConfig, false, false, null));
                return authServiceBackendTestResult;
            }
            if (this.isAuthenticated(connection, user.get(), credentials)) {
                AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createSuccess("Successfully logged in <" + credentials.username() + "> into " + testConfig.servers(), this.createTestResult(testConfig, true, true, user.get()));
                return authServiceBackendTestResult;
            }
            AuthServiceBackendTestResult authServiceBackendTestResult = AuthServiceBackendTestResult.createFailure("Login for user <" + credentials.username() + "> failed", this.createTestResult(testConfig, true, false, user.get()));
            return authServiceBackendTestResult;
        }
        catch (Exception e) {
            return AuthServiceBackendTestResult.createFailure("Couldn't test user login on " + testConfig.servers(), Collections.singletonList(e.getMessage()));
        }
    }

    private ADAuthServiceBackendConfig buildTestConfig(@Nullable AuthServiceBackendDTO existingBackendConfig) {
        ADAuthServiceBackendConfig.Builder newConfigBuilder = this.config.toBuilder();
        if (this.config.systemUserPassword().isKeepValue() && existingBackendConfig != null) {
            ADAuthServiceBackendConfig existingConfig = (ADAuthServiceBackendConfig)existingBackendConfig.config();
            newConfigBuilder.systemUserPassword(existingConfig.systemUserPassword());
        }
        return newConfigBuilder.build();
    }

    private Map<String, Object> createTestResult(ADAuthServiceBackendConfig config, boolean userExists, boolean loginSuccess, @Nullable LDAPUser user) {
        ImmutableMap.Builder userDetails = ImmutableMap.builder().put((Object)"user_exists", (Object)userExists).put((Object)"login_success", (Object)loginSuccess);
        if (user != null) {
            userDetails.put((Object)"user_details", (Object)ImmutableMap.of((Object)"dn", (Object)user.dn(), (Object)AD_OBJECT_GUID, (Object)user.base64UniqueId(), (Object)config.userNameAttribute(), (Object)user.username(), (Object)config.userFullNameAttribute(), (Object)user.fullName(), (Object)"email", (Object)user.email()));
        } else {
            userDetails.put((Object)"user_details", (Object)ImmutableMap.of());
        }
        return userDetails.build();
    }

    public static interface Factory
    extends AuthServiceBackend.Factory<ADAuthServiceBackend> {
        @Override
        public ADAuthServiceBackend create(AuthServiceBackendDTO var1);
    }
}

