/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.users.PaginatedUserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserOverviewDTO;

@Path(value="/system/authentication/services")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services", description="Manage authentication services")
@RequiresAuthentication
public class AuthServicesResource
extends RestResource {
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"username", (Object)SearchQueryField.create("username")).put((Object)"full_name", (Object)SearchQueryField.create("full_name")).put((Object)"email", (Object)SearchQueryField.create("email")).build();
    private final GlobalAuthServiceConfig authServiceConfig;
    private final PaginatedUserService userService;
    private final DBAuthServiceBackendService backendService;
    private final RoleService roleService;
    private final SearchQueryParser userSearchQueryParser;

    @Inject
    public AuthServicesResource(GlobalAuthServiceConfig authServiceConfig, PaginatedUserService userService, DBAuthServiceBackendService backendService, RoleService roleService) {
        this.authServiceConfig = authServiceConfig;
        this.userService = userService;
        this.backendService = backendService;
        this.roleService = roleService;
        this.userSearchQueryParser = new SearchQueryParser("full_name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Path(value="active-backend")
    @ApiOperation(value="Get active authentication service backend")
    @RequiresPermissions(value={"authserviceglobalconfig:read"})
    public Response get() {
        Optional<AuthServiceBackendDTO> activeConfig = this.getActiveBackendConfig();
        HashMap<String, Map<String, Long>> response = new HashMap<String, Map<String, Long>>();
        response.put("backend", activeConfig.orElse(null));
        response.put("context", Collections.singletonMap("backends_total", this.backendService.countBackends()));
        return Response.ok(response).build();
    }

    @GET
    @Path(value="active-backend/users")
    @ApiOperation(value="Get paginated users for active authentication service backend")
    @RequiresPermissions(value={"authserviceglobalconfig:read", "users:list"})
    public PaginatedResponse<UserOverviewDTO> getUsers(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="username,full_name,email") @DefaultValue(value="full_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        AuthServiceBackendDTO activeConfig = this.getActiveBackendConfig().orElseThrow(() -> new javax.ws.rs.NotFoundException("No active authentication service backend found"));
        PaginatedList<UserOverviewDTO> userList = this.userService.findPaginatedByAuthServiceBackend(this.parseSearchQuery(query), page, perPage, sort, order, activeConfig.id());
        return PaginatedResponse.create("users", userList, query, Collections.singletonMap("roles", this.createRoleContext((List<UserOverviewDTO>)userList.delegate())));
    }

    private Map<String, Object> createRoleContext(List<UserOverviewDTO> userList) {
        Set<String> roleIds = userList.stream().flatMap(user -> user.roles().stream()).collect(Collectors.toSet());
        try {
            return this.roleService.findIdMap(roleIds).values().stream().map(role -> Maps.immutableEntry((Object)role.getId(), Collections.singletonMap("title", role.getName()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (NotFoundException e) {
            throw new javax.ws.rs.NotFoundException("Couldn't find roles: " + roleIds);
        }
    }

    private SearchQuery parseSearchQuery(String query) {
        try {
            return this.userSearchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
    }

    private Optional<AuthServiceBackendDTO> getActiveBackendConfig() {
        Optional<AuthServiceBackendDTO> activeConfig = this.authServiceConfig.getActiveBackendConfig();
        activeConfig.ifPresent(backend -> this.checkPermission("authservicebackend:read", backend.id()));
        return activeConfig;
    }
}

