/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authzroles;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authzroles.AuthzRoleDTO;
import org.graylog.security.authzroles.PaginatedAuthzRolesService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.PaginatedUserService;
import org.graylog2.users.UserOverviewDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Authorization/Roles", description="Manage roles")
@Path(value="/authz/roles")
@Produces(value={"application/json"})
public class AuthzRolesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);
    protected static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"name", (Object)SearchQueryField.create("name")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    protected static final ImmutableMap<String, SearchQueryField> USER_SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"username", (Object)SearchQueryField.create("username")).put((Object)"full_name", (Object)SearchQueryField.create("full_name")).put((Object)"email", (Object)SearchQueryField.create("email")).build();
    private final PaginatedAuthzRolesService authzRolesService;
    private final PaginatedUserService paginatedUserService;
    private final UserService userService;
    private final SearchQueryParser searchQueryParser;
    private final SearchQueryParser userSearchQueryParser;

    @Inject
    public AuthzRolesResource(PaginatedAuthzRolesService authzRolesService, PaginatedUserService paginatedUserService, UserService userService) {
        this.authzRolesService = authzRolesService;
        this.paginatedUserService = paginatedUserService;
        this.userService = userService;
        this.searchQueryParser = new SearchQueryParser("name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
        this.userSearchQueryParser = new SearchQueryParser("username", (Map<String, SearchQueryField>)USER_SEARCH_FIELD_MAPPING);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a paginated list of all roles")
    @RequiresPermissions(value={"roles:read"})
    public PaginatedResponse<AuthzRoleDTO> getList(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name,description") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<AuthzRoleDTO> result = this.authzRolesService.findPaginated(searchQuery, page, perPage, sort, order);
        return PaginatedResponse.create("roles", result, query);
    }

    @GET
    @ApiOperation(value="Get a paginated list of users for a role")
    @Path(value="/{roleId}/assignees")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"users:list"})
    public PaginatedResponse<UserOverviewDTO> getUsersForRole(@ApiParam(name="roleId") @PathParam(value="roleId") @NotEmpty String roleId, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="username,full_name,email") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.userSearchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<UserOverviewDTO> result = this.paginatedUserService.findPaginatedByRole(searchQuery, page, perPage, sort, order, roleId);
        Set<String> roleIds = result.stream().flatMap(u -> u.roles().stream()).collect(Collectors.toSet());
        Map<String, String> rolesMap = this.authzRolesService.findPaginatedByIds(new SearchQuery(""), 0, 0, "name", "asc", roleIds).stream().collect(Collectors.toMap(AuthzRoleDTO::id, AuthzRoleDTO::name));
        List users = result.stream().map(u -> {
            Set<String> roleNames = u.roles().stream().map(rolesMap::get).collect(Collectors.toSet());
            return u.toBuilder().roles(roleNames).build();
        }).collect(Collectors.toList());
        PaginatedList enrichedResult = new PaginatedList(users, result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        return PaginatedResponse.create("users", enrichedResult, query);
    }

    @GET
    @ApiOperation(value="Get a single role")
    @Path(value="{roleId}")
    @Produces(value={"application/json"})
    public AuthzRoleDTO get(@ApiParam(name="roleId") @PathParam(value="roleId") @NotBlank String roleId) {
        this.checkPermission("roles:read", roleId);
        return (AuthzRoleDTO)this.authzRolesService.get(roleId).orElseThrow(() -> new NotFoundException("Could not find role with id: " + roleId));
    }

    @GET
    @ApiOperation(value="Get a paginated list roles for a user")
    @Path(value="/user/{username}")
    @RequiresPermissions(value={"roles:read"})
    public PaginatedResponse<AuthzRoleDTO> getListForUser(@ApiParam(name="username") @PathParam(value="username") @NotEmpty String username, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name,description") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        User user = Optional.ofNullable(this.userService.load(username)).orElseThrow(() -> new NotFoundException("Couldn't find user: " + username));
        PaginatedList<AuthzRoleDTO> result = this.authzRolesService.findPaginatedByIds(searchQuery, page, perPage, sort, order, user.getRoleIds());
        return PaginatedResponse.create("roles", result, query);
    }

    @PUT
    @Produces(value={"application/json"})
    @ApiOperation(value="Add user to role")
    @AuditEvent(type="server:role_membership:update")
    @Path(value="{roleId}/assignees")
    public void addUser(@ApiParam(name="roleId") @PathParam(value="roleId") @NotBlank String roleId, @ApiParam(name="usernames") Set<String> usernames) throws ValidationException {
        this.updateUserRole(roleId, usernames, Set::add);
    }

    @DELETE
    @ApiOperation(value="Remove user from role")
    @Path(value="{roleId}/assignee/{username}")
    @AuditEvent(type="server:role_membership:delete")
    public void removeUser(@ApiParam(name="roleId") @PathParam(value="roleId") @NotBlank String roleId, @ApiParam(name="username") @PathParam(value="username") @NotBlank String username) throws ValidationException {
        this.updateUserRole(roleId, (Set<String>)ImmutableSet.of((Object)username), Set::remove);
    }

    private void updateUserRole(String roleId, Set<String> usernames, UpdateRoles rolesUpdater) throws ValidationException {
        usernames.forEach(username -> {
            this.checkPermission("users:edit", (String)username);
            User user = this.userService.load((String)username);
            if (user == null) {
                throw new NotFoundException("Cannot find user with name: " + username);
            }
            this.authzRolesService.get(roleId).orElseThrow(() -> new NotFoundException("Cannot find role with id: " + roleId));
            Set<String> roles = user.getRoleIds();
            rolesUpdater.update(roles, roleId);
            user.setRoleIds(roles);
            try {
                this.userService.save(user);
            }
            catch (ValidationException e) {
                LOG.warn("Could not update user: {}", username);
            }
        });
    }

    @DELETE
    @Path(value="{roleId}")
    @AuditEvent(type="server:role:delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a role")
    public void delete(@ApiParam(name="roleId") @PathParam(value="roleId") @NotBlank String roleId) {
        this.checkPermission("roles:edit");
        AuthzRoleDTO roleDTO = (AuthzRoleDTO)this.authzRolesService.get(roleId).orElseThrow(() -> new NotFoundException("Could not delete role with id: " + roleId));
        if (roleDTO.readOnly()) {
            throw new NotAllowedException("Cannot delete read only role with id: " + roleId, new String[0]);
        }
        this.authzRolesService.delete(roleId);
    }

    static interface UpdateRoles {
        public boolean update(Set<String> var1, String var2);
    }
}

