/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptorService;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog.security.rest.AutoValue_GrantsOverviewResource_GrantSummary;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Authorization/GrantsOverview", description="Grants overview")
@Path(value="/authz/grants-overview")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class GrantsOverviewResource
extends RestResource {
    private final DBGrantService grantService;
    private final GRNDescriptorService descriptorService;

    @Inject
    public GrantsOverviewResource(DBGrantService grantService, GRNDescriptorService descriptorService) {
        this.grantService = grantService;
        this.descriptorService = descriptorService;
    }

    @GET
    @ApiOperation(value="Return an overview of all grants in the system")
    @RequiresPermissions(value={"grantsoverview:read"})
    public Response getOverview() {
        Set grants = this.grantService.getAll().stream().map(grant -> GrantSummary.of(grant, this.descriptorService)).collect(Collectors.toSet());
        return Response.ok(Collections.singletonMap("grants", grants)).build();
    }

    @AutoValue
    public static abstract class GrantSummary {
        @JsonProperty(value="id")
        public abstract String id();

        @JsonProperty(value="grantee")
        public abstract GRN grantee();

        @JsonProperty(value="grantee_title")
        public abstract String granteeTitle();

        @JsonProperty(value="capability")
        public abstract Capability capability();

        @JsonProperty(value="target")
        public abstract GRN target();

        @JsonProperty(value="target_title")
        public abstract String targetTitle();

        @JsonProperty(value="created_by")
        public abstract String createdBy();

        @JsonProperty(value="created_at")
        public abstract ZonedDateTime createdAt();

        @JsonProperty(value="updated_by")
        public abstract String updatedBy();

        @JsonProperty(value="updated_at")
        public abstract ZonedDateTime updatedAt();

        @JsonProperty(value="expires_at")
        public abstract Optional<ZonedDateTime> expiresAt();

        public static GrantSummary of(GrantDTO grant, GRNDescriptorService descriptorService) {
            return GrantSummary.builder().id(grant.id()).grantee(grant.grantee()).granteeTitle(grant.grantee().type() + ": " + descriptorService.getDescriptor(grant.grantee()).title()).capability(grant.capability()).target(grant.target()).targetTitle(grant.target().type() + ": " + descriptorService.getDescriptor(grant.target()).title()).createdBy(grant.createdBy()).createdAt(grant.createdAt()).updatedBy(grant.updatedBy()).updatedAt(grant.updatedAt()).expiresAt(grant.expiresAt().orElse(null)).build();
        }

        public static Builder builder() {
            return new AutoValue_GrantsOverviewResource_GrantSummary.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder grantee(GRN var1);

            public abstract Builder granteeTitle(String var1);

            public abstract Builder capability(Capability var1);

            public abstract Builder target(GRN var1);

            public abstract Builder targetTitle(String var1);

            public abstract Builder createdBy(String var1);

            public abstract Builder createdAt(ZonedDateTime var1);

            public abstract Builder updatedBy(String var1);

            public abstract Builder updatedAt(ZonedDateTime var1);

            public abstract Builder expiresAt(@Nullable ZonedDateTime var1);

            public abstract GrantSummary build();
        }
    }
}

