/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20200803120800_GrantsMigrations;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.GrantsMetaMigration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPermissionsToGrantsMigration {
    private static final Logger LOG = LoggerFactory.getLogger(UserPermissionsToGrantsMigration.class);
    private final UserService userService;
    private final DBGrantService dbGrantService;
    private final GRNRegistry grnRegistry;
    private final String rootUsername;

    public UserPermissionsToGrantsMigration(UserService userService, DBGrantService dbGrantService, GRNRegistry grnRegistry, @Named(value="root_username") String rootUsername) {
        this.userService = userService;
        this.dbGrantService = dbGrantService;
        this.grnRegistry = grnRegistry;
        this.rootUsername = rootUsername;
    }

    public void upgrade() {
        List<User> users = this.userService.loadAll();
        for (User user : users) {
            Map<String, Set<String>> migratableEntities = this.getMigratableEntities((Set<String>)ImmutableSet.copyOf(user.getPermissions()));
            if (migratableEntities.isEmpty()) continue;
            this.migrateUserPermissions(user, migratableEntities);
        }
    }

    private void migrateUserPermissions(User user, Map<String, Set<String>> migratableEntities) {
        migratableEntities.forEach((entityID, permissions) -> {
            GrantsMetaMigration.GRNTypeCapability grnTypeCapability = GrantsMetaMigration.MIGRATION_MAP.get(permissions);
            if (grnTypeCapability != null) {
                Capability capability = grnTypeCapability.capability;
                GRNType grnType = grnTypeCapability.grnType;
                this.dbGrantService.ensure(this.grnRegistry.ofUser(user), capability, grnType.toGRN((String)entityID), this.rootUsername);
                List<String> updatedPermissions = user.getPermissions();
                updatedPermissions.removeAll(permissions.stream().map(p -> p + ":" + entityID).collect(Collectors.toSet()));
                user.setPermissions(updatedPermissions);
                try {
                    this.userService.save(user);
                }
                catch (ValidationException e) {
                    LOG.error("Failed to update permssions on user <{}>", (Object)user.getName(), (Object)e);
                }
                LOG.info("Migrating entity <{}> permissions <{}> to <{}> grant for user <{}>", new Object[]{grnType.toGRN((String)entityID), permissions, capability, user.getName()});
            } else {
                LOG.info("Skipping non-migratable entity <{}>. Permissions <{}> cannot be converted to a grant capability", entityID, permissions);
            }
        });
    }

    private Map<String, Set<String>> getMigratableEntities(Set<String> permissions) {
        HashMap<String, Set<String>> migratableEntities = new HashMap<String, Set<String>>();
        permissions.stream().map(GrantsMetaMigration.MigrationWildcardPermission::new).filter(p -> p.getParts().size() == 3 && p.getParts().stream().allMatch(part -> part.size() == 1)).forEach(p -> {
            String permissionType = p.subPart(0);
            String restPermission = p.subPart(0) + ":" + p.subPart(1);
            String id = p.subPart(2);
            if (GrantsMetaMigration.MIGRATION_MAP.keySet().stream().flatMap(Collection::stream).anyMatch(perm -> perm.startsWith(permissionType + ":"))) {
                if (migratableEntities.containsKey(id)) {
                    ((Set)migratableEntities.get(id)).add(restPermission);
                } else {
                    migratableEntities.put(id, Sets.newHashSet((Object[])new String[]{restPermission}));
                }
            }
        });
        return migratableEntities;
    }
}

