/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.debug;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.debug.DebugEvent;
import org.graylog2.system.debug.DebugEventHolder;

@RequiresAuthentication
@Api(value="System/Debug/Events", description="For debugging local and cluster events.")
@Path(value="/system/debug/events")
@Produces(value={"application/json"})
public class DebugEventsResource
extends RestResource {
    private final NodeId nodeId;
    private final EventBus serverEventBus;
    private final EventBus clusterEventBus;

    @Inject
    public DebugEventsResource(NodeId nodeId, EventBus serverEventBus, ClusterEventBus clusterEventBus) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.serverEventBus = (EventBus)Preconditions.checkNotNull((Object)serverEventBus);
        this.clusterEventBus = (EventBus)Preconditions.checkNotNull((Object)((Object)clusterEventBus));
    }

    @Timed
    @POST
    @Path(value="/cluster")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Create and send a cluster debug event.")
    @NoAuditEvent(value="only used to create a debug event")
    public void generateClusterDebugEvent(@ApiParam(name="text", defaultValue="Cluster Test") @Nullable String text) {
        this.clusterEventBus.post((Object)DebugEvent.create(this.nodeId.toString(), Strings.isNullOrEmpty((String)text) ? "Cluster Test" : text));
    }

    @Timed
    @POST
    @Path(value="/local")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Create and send a local debug event.")
    @NoAuditEvent(value="only used to create a debug event")
    public void generateDebugEvent(@ApiParam(name="text", defaultValue="Local Test") @Nullable String text) {
        this.serverEventBus.post((Object)DebugEvent.create(this.nodeId.toString(), Strings.isNullOrEmpty((String)text) ? "Local Test" : text));
    }

    @Timed
    @GET
    @Path(value="/cluster")
    @ApiOperation(value="Show last received cluster debug event.", response=DebugEvent.class)
    public DebugEvent showLastClusterDebugEvent() {
        return DebugEventHolder.getClusterDebugEvent();
    }

    @Timed
    @GET
    @Path(value="/local")
    @ApiOperation(value="Show last received local debug event.", response=DebugEvent.class)
    public DebugEvent showLastDebugEvent() {
        return DebugEventHolder.getLocalDebugEvent();
    }
}

